=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::ChartSeriesGroup;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ChartLinesFormat;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Chart series group. Defines common properties for a group of series.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Chart series group. Defines common properties for a group of series.',
                                  class => 'ChartSeriesGroup',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'type' => {
    	datatype => 'string',
    	base_name => 'Type',
    	description => 'Returns a type of this series group.',
    	format => '',
    	read_only => '',
    		},
    'gap_width' => {
    	datatype => 'int',
    	base_name => 'GapWidth',
    	description => 'Specifies the space between bar or column clusters, as a percentage of the bar or column width.',
    	format => '',
    	read_only => '',
    		},
    'gap_depth' => {
    	datatype => 'int',
    	base_name => 'GapDepth',
    	description => 'Returns or sets the distance, as a percentage of the marker width, between the data series in a 3D chart.',
    	format => '',
    	read_only => '',
    		},
    'first_slice_angle' => {
    	datatype => 'int',
    	base_name => 'FirstSliceAngle',
    	description => 'Gets or sets the angle of the first pie or doughnut chart slice,  in degrees (clockwise from up, from 0 to 360 degrees).',
    	format => '',
    	read_only => '',
    		},
    'is_color_varied' => {
    	datatype => 'boolean',
    	base_name => 'IsColorVaried',
    	description => 'Specifies that each data marker in the series has a different color.',
    	format => '',
    	read_only => '',
    		},
    'has_series_lines' => {
    	datatype => 'boolean',
    	base_name => 'HasSeriesLines',
    	description => 'True if chart has series lines. Applied to stacked bar and OfPie charts.',
    	format => '',
    	read_only => '',
    		},
    'overlap' => {
    	datatype => 'int',
    	base_name => 'Overlap',
    	description => 'Specifies how much bars and columns shall overlap on 2-D charts (from -100 to 100).',
    	format => '',
    	read_only => '',
    		},
    'second_pie_size' => {
    	datatype => 'int',
    	base_name => 'SecondPieSize',
    	description => 'Specifies the size of the second pie or bar of a pie-of-pie chart or  a bar-of-pie chart, as a percentage of the size of the first pie (can  be between 5 and 200 percents).',
    	format => '',
    	read_only => '',
    		},
    'pie_split_position' => {
    	datatype => 'double',
    	base_name => 'PieSplitPosition',
    	description => 'Specifies a value that shall be used to determine which data points  are in the second pie or bar on a pie-of-pie or bar-of-pie chart.  Is used together with PieSplitBy property.',
    	format => '',
    	read_only => '',
    		},
    'pie_split_by' => {
    	datatype => 'string',
    	base_name => 'PieSplitBy',
    	description => 'Specifies how to determine which data points are in the second pie or bar  on a pie-of-pie or bar-of-pie chart.',
    	format => '',
    	read_only => '',
    		},
    'doughnut_hole_size' => {
    	datatype => 'int',
    	base_name => 'DoughnutHoleSize',
    	description => 'Specifies the size of the hole in a doughnut chart (can be between 10 and 90 percents  of the size of the plot area.).',
    	format => '',
    	read_only => '',
    		},
    'bubble_size_scale' => {
    	datatype => 'int',
    	base_name => 'BubbleSizeScale',
    	description => 'Specifies the scale factor for the bubble chart (can be  between 0 and 300 percents of the default size). Read/write Int32.',
    	format => '',
    	read_only => '',
    		},
    'hi_low_lines_format' => {
    	datatype => 'ChartLinesFormat',
    	base_name => 'HiLowLinesFormat',
    	description => 'Specifies HiLowLines format.  HiLowLines applied with HiLowClose, OpenHiLowClose, VolumeHiLowClose and VolumeOpenHiLowClose chart types.',
    	format => '',
    	read_only => '',
    		},
    'bubble_size_representation' => {
    	datatype => 'string',
    	base_name => 'BubbleSizeRepresentation',
    	description => 'Specifies how the bubble size values are represented on the bubble chart. Read/write BubbleSizeRepresentationType.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'type' => 'string',
    'gap_width' => 'int',
    'gap_depth' => 'int',
    'first_slice_angle' => 'int',
    'is_color_varied' => 'boolean',
    'has_series_lines' => 'boolean',
    'overlap' => 'int',
    'second_pie_size' => 'int',
    'pie_split_position' => 'double',
    'pie_split_by' => 'string',
    'doughnut_hole_size' => 'int',
    'bubble_size_scale' => 'int',
    'hi_low_lines_format' => 'ChartLinesFormat',
    'bubble_size_representation' => 'string'
} );

__PACKAGE__->attribute_map( {
    'type' => 'Type',
    'gap_width' => 'GapWidth',
    'gap_depth' => 'GapDepth',
    'first_slice_angle' => 'FirstSliceAngle',
    'is_color_varied' => 'IsColorVaried',
    'has_series_lines' => 'HasSeriesLines',
    'overlap' => 'Overlap',
    'second_pie_size' => 'SecondPieSize',
    'pie_split_position' => 'PieSplitPosition',
    'pie_split_by' => 'PieSplitBy',
    'doughnut_hole_size' => 'DoughnutHoleSize',
    'bubble_size_scale' => 'BubbleSizeScale',
    'hi_low_lines_format' => 'HiLowLinesFormat',
    'bubble_size_representation' => 'BubbleSizeRepresentation'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
