unit module Transit::Network::Helpers:ver<0.0.2>;

our sub dehourify ($string is copy) is export # E.g. "1h30" -> "90".
{
  return $string unless $string ~~ /<[dh]>/;

  my $min = 0;

  if $string ~~ /^(\d+)d(.*)/
  {
    $min    = $0 * 60 * 24;
    $string = $1.Str;
  }

  if $string ~~ /^(\d+)h(.*)/
  {
    $min   += $0 * 60;
    $string = $1.Str;
  }

  $min += $string;

  return $min;
}

sub dehourify-interval($interval) is export
{
  return $interval.split(";").map({ dehourify($_) }).join(';');
}

sub min2dep ($string) is export
{
  my @depts = $string.split(/\s+/);

  return @depts.map({ $_.chars == 2 ?? "00$_" !! "00$_.substr(0,2).5" });
}

sub dep-add (@depts, $add) is export
{
  my @return;
  for @depts -> $current
  {
    my $new = $current + $add;
    @return.push: $new ~~ /\.5^/ ?? ( "0" x (6 - $new.chars) ~ $new ) !! ("0" x (4 - $new.chars) ~ $new  );
  }

  return @return;
}

sub nice-time ($time is copy, :$days) is export
{
  my $half = " ";
  
  if $time ~~ /(\d+)\.5$/
  {
    $time = $0;
    $half = "'";
  }

  my ($min, $hour) = $time.Int.polymod(60);

  if $days
  {
    my $day = $hour div 24;
    $hour   = $hour - $day * 24;

    $day == 0
      ?? return "  { $hour.fmt('%02d') }{ $min.fmt('%02d') }{ $half }"
      !! return "{$day}+{ $hour.fmt('%02d') }{ $min.fmt('%02d') }{ $half }";
  }

  return "{ $hour.fmt('%02d') }{ $min.fmt('%02d') }{ $half }";
}