/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.service.jmx.handler.list.DataKeys;

public class ConstructorDataUpdater
extends DataUpdater {
    protected ConstructorDataUpdater() {
        super(100);
    }

    public String getKey() {
        return DataKeys.CONSTRUCTORS.getKey();
    }

    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pName) {
        JSONObject opMap = new JSONObject();
        for (MBeanConstructorInfo ctorInfo : pMBeanInfo.getConstructors()) {
            if (pName != null && !ctorInfo.getName().equals(pName)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray(ctorInfo.getSignature().length);
            for (MBeanParameterInfo paramInfo : ctorInfo.getSignature()) {
                JSONObject args = new JSONObject();
                args.put((Object)DataKeys.DESCRIPTION.getKey(), (Object)paramInfo.getDescription());
                args.put((Object)DataKeys.NAME.getKey(), (Object)paramInfo.getName());
                args.put((Object)DataKeys.TYPE.getKey(), (Object)paramInfo.getType());
                argList.add((Object)args);
            }
            map.put((Object)DataKeys.ARGS.getKey(), (Object)argList);
            map.put((Object)DataKeys.DESCRIPTION.getKey(), (Object)ctorInfo.getDescription());
            JsonUtil.addJSONObjectToJSONObject((JSONObject)opMap, (String)ctorInfo.getName(), (JSONObject)map);
        }
        return opMap;
    }
}

