/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MessageSupport;

public class CONNACK
implements MessageSupport.Message {
    public static final byte TYPE = 2;
    private Code code = Code.CONNECTION_ACCEPTED;

    public byte messageType() {
        return 2;
    }

    public CONNACK decode(MQTTFrame frame) throws ProtocolException {
        assert (frame.buffers.length == 1);
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        is.skip(1);
        byte c = is.readByte();
        if (c >= Code.values().length) {
            throw new ProtocolException("Invalid CONNACK encoding");
        }
        this.code = Code.values()[c];
        return this;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(2);
            os.writeByte(0);
            os.writeByte(this.code.ordinal());
            MQTTFrame frame = new MQTTFrame();
            frame.commandType(2);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public Code code() {
        return this.code;
    }

    public CONNACK code(Code code) {
        this.code = code;
        return this;
    }

    public String toString() {
        return "CONNACK{code=" + (Object)((Object)this.code) + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        CONNECTION_ACCEPTED,
        CONNECTION_REFUSED_UNACCEPTED_PROTOCOL_VERSION,
        CONNECTION_REFUSED_IDENTIFIER_REJECTED,
        CONNECTION_REFUSED_SERVER_UNAVAILABLE,
        CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD,
        CONNECTION_REFUSED_NOT_AUTHORIZED;

    }
}

