/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;

public interface CamelEvent {
    public Type getType();

    public Object getSource();

    public long getTimestamp();

    public void setTimestamp(long var1);

    public static interface ExchangeAsyncProcessingStartedEvent
    extends ExchangeEvent {
        @Override
        default public Type getType() {
            return Type.ExchangeAsyncProcessingStarted;
        }
    }

    public static interface ServiceStopFailureEvent
    extends ServiceEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.ServiceStopFailure;
        }
    }

    public static interface ServiceStartupFailureEvent
    extends ServiceEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.ServiceStartupFailure;
        }
    }

    public static interface ServiceEvent
    extends CamelEvent {
        public Object getService();

        @Override
        default public Object getSource() {
            return this.getService();
        }
    }

    public static interface RouteRestartingFailureEvent
    extends RouteEvent,
    FailureEvent {
        public long getAttempt();

        public boolean isExhausted();

        @Override
        default public Type getType() {
            return Type.RouteRestartingFailure;
        }
    }

    public static interface RouteRestartingEvent
    extends RouteEvent {
        public long getAttempt();

        @Override
        default public Type getType() {
            return Type.RouteRestarting;
        }
    }

    public static interface RouteStoppedEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteStopped;
        }
    }

    public static interface RouteStoppingEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteStopping;
        }
    }

    public static interface RouteStartedEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteStarted;
        }
    }

    public static interface RouteStartingEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteStarting;
        }
    }

    public static interface RouteReloadedEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteReloaded;
        }

        public int getIndex();

        public int getTotal();
    }

    public static interface RouteRemovedEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteRemoved;
        }
    }

    public static interface RouteAddedEvent
    extends RouteEvent {
        @Override
        default public Type getType() {
            return Type.RouteAdded;
        }
    }

    public static interface RouteEvent
    extends CamelEvent {
        public Route getRoute();

        @Override
        default public Object getSource() {
            return this.getRoute();
        }
    }

    public static interface StepFailedEvent
    extends StepEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.StepFailed;
        }
    }

    public static interface StepCompletedEvent
    extends StepEvent {
        @Override
        default public Type getType() {
            return Type.StepCompleted;
        }
    }

    public static interface StepStartedEvent
    extends StepEvent {
        @Override
        default public Type getType() {
            return Type.StepStarted;
        }
    }

    public static interface StepEvent
    extends ExchangeEvent {
        public String getStepId();
    }

    public static interface ExchangeSentEvent
    extends ExchangeEvent {
        public Endpoint getEndpoint();

        public long getTimeTaken();

        @Override
        default public Type getType() {
            return Type.ExchangeSent;
        }
    }

    public static interface ExchangeSendingEvent
    extends ExchangeEvent {
        public Endpoint getEndpoint();

        @Override
        default public Type getType() {
            return Type.ExchangeSending;
        }
    }

    public static interface ExchangeRedeliveryEvent
    extends ExchangeEvent {
        public int getAttempt();

        @Override
        default public Type getType() {
            return Type.ExchangeRedelivery;
        }
    }

    public static interface ExchangeFailureHandlingEvent
    extends ExchangeFailureEvent {
        @Override
        default public Type getType() {
            return Type.ExchangeFailureHandling;
        }
    }

    public static interface ExchangeFailureHandledEvent
    extends ExchangeFailureEvent {
        @Override
        default public Type getType() {
            return Type.ExchangeFailureHandled;
        }
    }

    public static interface ExchangeFailureEvent
    extends ExchangeEvent {
        public Processor getFailureHandler();

        public boolean isDeadLetterChannel();

        public String getDeadLetterUri();
    }

    public static interface ExchangeFailedEvent
    extends ExchangeEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.ExchangeFailed;
        }
    }

    public static interface ExchangeCreatedEvent
    extends ExchangeEvent {
        @Override
        default public Type getType() {
            return Type.ExchangeCreated;
        }
    }

    public static interface ExchangeCompletedEvent
    extends ExchangeEvent {
        @Override
        default public Type getType() {
            return Type.ExchangeCompleted;
        }
    }

    public static interface ExchangeEvent
    extends CamelEvent {
        public Exchange getExchange();

        @Override
        default public Object getSource() {
            return this.getExchange();
        }
    }

    public static interface CamelContextReloadFailureEvent
    extends CamelContextEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextReloadFailure;
        }
    }

    public static interface CamelContextReloadedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextReloaded;
        }
    }

    public static interface CamelContextReloadingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextReloading;
        }
    }

    public static interface CamelContextRoutesStoppedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.RoutesStopped;
        }
    }

    public static interface CamelContextRoutesStoppingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.RoutesStopping;
        }
    }

    public static interface CamelContextRoutesStartedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.RoutesStarted;
        }
    }

    public static interface CamelContextRoutesStartingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.RoutesStarting;
        }
    }

    public static interface CamelContextSuspendingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextSuspending;
        }
    }

    public static interface CamelContextSuspendedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextSuspended;
        }
    }

    public static interface CamelContextStoppingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextStopping;
        }
    }

    public static interface CamelContextStoppedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextStopped;
        }
    }

    public static interface CamelContextStopFailureEvent
    extends CamelContextEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextStopFailure;
        }
    }

    public static interface CamelContextStartupFailureEvent
    extends CamelContextEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextStartupFailure;
        }
    }

    public static interface CamelContextStartingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextStarting;
        }
    }

    public static interface CamelContextStartedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextStarted;
        }
    }

    public static interface CamelContextResumingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextResuming;
        }
    }

    public static interface CamelContextResumeFailureEvent
    extends CamelContextEvent,
    FailureEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextResumeFailure;
        }
    }

    public static interface CamelContextResumedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextResumed;
        }
    }

    public static interface CamelContextInitializedEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextInitialized;
        }
    }

    public static interface CamelContextInitializingEvent
    extends CamelContextEvent {
        @Override
        default public Type getType() {
            return Type.CamelContextInitializing;
        }
    }

    public static interface CamelContextEvent
    extends CamelEvent {
        public CamelContext getContext();

        @Override
        default public Object getSource() {
            return this.getContext();
        }
    }

    public static interface FailureEvent
    extends CamelEvent {
        public Throwable getCause();
    }

    public static enum Type {
        CamelContextInitializing,
        CamelContextInitialized,
        CamelContextResumed,
        CamelContextResumeFailure,
        CamelContextResuming,
        CamelContextStarted,
        CamelContextStarting,
        CamelContextStartupFailure,
        CamelContextStopFailure,
        CamelContextStopped,
        CamelContextStopping,
        CamelContextSuspended,
        CamelContextSuspending,
        CamelContextReloading,
        CamelContextReloaded,
        CamelContextReloadFailure,
        ExchangeCompleted,
        ExchangeCreated,
        ExchangeFailed,
        ExchangeFailureHandled,
        ExchangeFailureHandling,
        ExchangeRedelivery,
        ExchangeSending,
        ExchangeSent,
        ExchangeAsyncProcessingStarted,
        RoutesStarting,
        RoutesStarted,
        RoutesStopping,
        RoutesStopped,
        RouteAdded,
        RouteRemoved,
        RouteReloaded,
        RouteStarting,
        RouteStarted,
        RouteStopping,
        RouteStopped,
        RouteRestarting,
        RouteRestartingFailure,
        ServiceStartupFailure,
        ServiceStopFailure,
        StepStarted,
        StepCompleted,
        StepFailed,
        Custom;

    }
}

