/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.admin;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.admin.DistributedLogAdmin;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.DryrunLogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.LogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDLCK
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestDLCK.class);
    protected static DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(10L).setEnableLedgerAllocatorPool(true).setLedgerAllocatorPoolName("test");
    private ZooKeeperClient zkc;

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createDLMURI("/")).build();
    }

    @Override
    @After
    public void teardown() throws Exception {
        this.zkc.close();
    }

    static Map<Long, LogSegmentMetadata> getLogSegments(DistributedLogManager dlm) throws Exception {
        HashMap<Long, LogSegmentMetadata> logSegmentMap = new HashMap<Long, LogSegmentMetadata>();
        List segments = dlm.getLogSegments();
        for (LogSegmentMetadata segment : segments) {
            logSegmentMap.put(segment.getLogSegmentSequenceNumber(), segment);
        }
        return logSegmentMap;
    }

    static void verifyLogSegment(Map<Long, LogSegmentMetadata> segments, DLSN lastDLSN, long logSegmentSequenceNumber, int recordCount, long lastTxId) {
        LogSegmentMetadata segment = segments.get(logSegmentSequenceNumber);
        Assert.assertNotNull((Object)segment);
        Assert.assertEquals((Object)lastDLSN, (Object)segment.getLastDLSN());
        Assert.assertEquals((long)recordCount, (long)segment.getRecordCount());
        Assert.assertEquals((long)lastTxId, (long)segment.getLastTxId());
    }

    @Test(timeout=60000L)
    public void testCheckAndRepairDLNamespace() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setOutputBufferSize(0);
        confLocal.setLogSegmentSequenceNumberValidationEnabled(false);
        confLocal.setLogSegmentCacheEnabled(false);
        URI uri = this.createDLMURI("/check-and-repair-dl-namespace");
        this.zkc.get().create(uri.getPath(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).build();
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("dlck-tool").numThreads(1).build();
        ExecutorService executorService = Executors.newCachedThreadPool();
        String streamName = "check-and-repair-dl-namespace";
        DistributedLogManager dlm = namespace.openLog(streamName);
        DLMTestUtil.injectLogSegmentWithLastDLSN(dlm, confLocal, 1L, 1L, 10L, false);
        DLMTestUtil.injectLogSegmentWithLastDLSN(dlm, confLocal, 2L, 11L, 10L, true);
        DLMTestUtil.injectLogSegmentWithLastDLSN(dlm, confLocal, 3L, 21L, 10L, false);
        DLMTestUtil.injectLogSegmentWithLastDLSN(dlm, confLocal, 4L, 31L, 10L, true);
        DistributedLogAdmin.checkAndRepairDLNamespace((URI)uri, (Namespace)namespace, (MetadataUpdater)new DryrunLogSegmentMetadataStoreUpdater(confLocal, this.getLogSegmentMetadataStore(namespace)), (OrderedScheduler)scheduler, (boolean)false, (boolean)false);
        Map<Long, LogSegmentMetadata> segments = TestDLCK.getLogSegments(dlm);
        LOG.info("segments after drynrun {}", segments);
        TestDLCK.verifyLogSegment(segments, new DLSN(1L, 18L, 0L), 1L, 10, 10L);
        TestDLCK.verifyLogSegment(segments, new DLSN(2L, 16L, 0L), 2L, 9, 19L);
        TestDLCK.verifyLogSegment(segments, new DLSN(3L, 18L, 0L), 3L, 10, 30L);
        TestDLCK.verifyLogSegment(segments, new DLSN(4L, 16L, 0L), 4L, 9, 39L);
        DistributedLogAdmin.checkAndRepairDLNamespace((URI)uri, (Namespace)namespace, (MetadataUpdater)LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)confLocal, (LogSegmentMetadataStore)this.getLogSegmentMetadataStore(namespace)), (OrderedScheduler)scheduler, (boolean)false, (boolean)false);
        segments = TestDLCK.getLogSegments(dlm);
        LOG.info("segments after repair {}", segments);
        TestDLCK.verifyLogSegment(segments, new DLSN(1L, 18L, 0L), 1L, 10, 10L);
        TestDLCK.verifyLogSegment(segments, new DLSN(2L, 18L, 0L), 2L, 10, 20L);
        TestDLCK.verifyLogSegment(segments, new DLSN(3L, 18L, 0L), 3L, 10, 30L);
        TestDLCK.verifyLogSegment(segments, new DLSN(4L, 18L, 0L), 4L, 10, 40L);
        dlm.close();
        SchedulerUtils.shutdownScheduler((ExecutorService)executorService, (long)5L, (TimeUnit)TimeUnit.MINUTES);
        namespace.close();
    }
}

