/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.controller;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.controller.CommandClient;
import org.apache.zookeeper.server.controller.ControllerConfigTest;
import org.apache.zookeeper.server.controller.ControllerServerConfig;
import org.apache.zookeeper.server.controller.ControllerService;
import org.junit.After;
import org.junit.Before;
import org.junit.jupiter.api.Assertions;

public class ControllerTestBase
extends ZKTestCase {
    protected ControllerService controllerService;
    protected CommandClient commandClient;
    private File tempDirectory;
    protected ControllerServerConfig config;

    @Before
    public void init() throws Exception {
        List<Integer> openPorts = ControllerConfigTest.findNAvailablePorts(2);
        File tmpFile = File.createTempFile("test", ".junit", testBaseDir);
        this.tempDirectory = new File(tmpFile + ".dir");
        Assertions.assertFalse((boolean)this.tempDirectory.exists());
        Assertions.assertTrue((boolean)this.tempDirectory.mkdirs());
        this.config = new ControllerServerConfig(openPorts.get(0).intValue(), openPorts.get(1).intValue(), this.tempDirectory.getAbsolutePath());
        this.controllerService = new ControllerService();
        this.controllerService.start(this.config);
        int retries = 50;
        while (!this.controllerService.isReady()) {
            Thread.sleep(100L);
            if (--retries >= 0) continue;
            throw new TimeoutException("Service didn't start up and finish elections.");
        }
        this.commandClient = new CommandClient(this.config.getControllerAddress().getPort());
    }

    @After
    public void cleanup() throws InterruptedException {
        if (this.controllerService != null) {
            this.controllerService.shutdown();
        }
        if (this.commandClient != null) {
            this.commandClient.close();
        }
        if (this.tempDirectory != null) {
            this.tempDirectory.delete();
        }
    }
}

