/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCnxnTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ServerCnxnTest.class);
    private static int cnxnTimeout = 1000;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zookeeper.nio.sessionlessCnxnTimeout", Integer.toString(cnxnTimeout));
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("zookeeper.nio.sessionlessCnxnTimeout");
    }

    @Test
    public void testServerCnxnExpiry() throws Exception {
        this.verify("ruok", "imok");
        String resp = this.sendRequest("ruok", 2 * cnxnTimeout + 1000);
        Assertions.assertEquals((Object)"", (Object)resp, (String)"Connection should have closed");
    }

    private void verify(String cmd, String expected) throws IOException {
        String resp = this.sendRequest(cmd, 0);
        LOG.info("cmd {} expected {} got {}", new Object[]{cmd, expected, resp});
        Assertions.assertTrue((boolean)resp.contains(expected));
    }

    private String sendRequest(String cmd, int delay) throws IOException {
        ClientBase.HostPort hpobj = ClientBase.parseHostPortList(this.hostPort).get(0);
        return ServerCnxnTest.send4LetterWord(hpobj.host, hpobj.port, cmd, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String send4LetterWord(String host, int port, String cmd, int delay) throws IOException {
        LOG.info("connecting to {} {}", (Object)host, (Object)port);
        Socket sock = new Socket(host, port);
        BufferedReader reader = null;
        try {
            try {
                LOG.info("Sleeping for {}ms", (Object)delay);
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes());
            outstream.flush();
            sock.shutdownOutput();
            reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            StringBuilder sb = ServerCnxnTest.readLine(reader);
            String string = sb.toString();
            return string;
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static StringBuilder readLine(BufferedReader reader) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioe) {
            LOG.info("Connnection is expired", (Throwable)ioe);
        }
        return sb;
    }
}

