/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.vint.VIntCoding;

public final class ForwardingInfo
implements Serializable {
    final List<InetAddressAndPort> targets;
    final long[] messageIds;
    static final IVersionedSerializer<ForwardingInfo> serializer = new IVersionedSerializer<ForwardingInfo>(){

        @Override
        public void serialize(ForwardingInfo forwardTo, DataOutputPlus out, int version) throws IOException {
            assert (version >= 12);
            long[] ids = forwardTo.messageIds;
            List<InetAddressAndPort> targets = forwardTo.targets;
            int count = ids.length;
            out.writeUnsignedVInt32(count);
            for (int i = 0; i < count; ++i) {
                InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(targets.get(i), out, version);
                out.writeUnsignedVInt(ids[i]);
            }
        }

        @Override
        public long serializedSize(ForwardingInfo forwardTo, int version) {
            assert (version >= 12);
            long[] ids = forwardTo.messageIds;
            List<InetAddressAndPort> targets = forwardTo.targets;
            int count = ids.length;
            long size = VIntCoding.computeUnsignedVIntSize(count);
            for (int i = 0; i < count; ++i) {
                size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(targets.get(i), version);
                size += (long)VIntCoding.computeUnsignedVIntSize(ids[i]);
            }
            return size;
        }

        @Override
        public ForwardingInfo deserialize(DataInputPlus in, int version) throws IOException {
            assert (version >= 12);
            int count = in.readUnsignedVInt32();
            long[] ids = new long[count];
            ArrayList<InetAddressAndPort> targets = new ArrayList<InetAddressAndPort>(count);
            for (int i = 0; i < count; ++i) {
                targets.add(InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version));
                ids[i] = in.readUnsignedVInt32();
            }
            return new ForwardingInfo(targets, ids);
        }
    };

    public ForwardingInfo(List<InetAddressAndPort> targets, long[] messageIds) {
        Preconditions.checkArgument((targets.size() == messageIds.length ? 1 : 0) != 0);
        this.targets = targets;
        this.messageIds = messageIds;
    }

    public void forEach(BiConsumer<Long, InetAddressAndPort> biConsumer) {
        for (int i = 0; i < this.messageIds.length; ++i) {
            biConsumer.accept(this.messageIds[i], this.targets.get(i));
        }
    }
}

