/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.TemplateDebugger;
import org.apache.commons.jexl3.internal.TemplateInterpreter;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JXLTTest
extends JexlTestCase {
    private static final Log LOGGER = LogFactory.getLog(JxltEngine.class);
    private static final Permissions NOJEXL3 = new Permissions(){

        public boolean allow(Class<?> clazz) {
            String cname = clazz.getName();
            return !cname.contains("jexl3") || cname.contains("311");
        }
    };
    private final MapContext vars = new MapContext();
    private JexlEvalContext context;
    private JexlBuilder BUILDER;
    private JexlEngine ENGINE;
    private JxltEngine JXLT;

    public static List<JexlBuilder> engines() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true).lexicalShade(true);
        return Arrays.asList(new JexlBuilder().silent(false).lexical(true).lexicalShade(true).cache(128).strict(true), new JexlBuilder().features(f).silent(false).cache(128).strict(true), new JexlBuilder().silent(false).cache(128).strict(true));
    }

    private static String refactor(TemplateDebugger td, JxltEngine.Template ts) {
        boolean dbg = td.debug(ts);
        if (dbg) {
            return td.toString();
        }
        return "";
    }

    public JXLTTest() {
        super("JXLTTest");
    }

    boolean contains(Set<List<String>> set, List<String> list) {
        for (List<String> sl : set) {
            if (!sl.equals(list)) continue;
            return true;
        }
        return false;
    }

    private String getSource(String tostring) {
        int len = tostring.length();
        int sc = tostring.lastIndexOf(" /*= ");
        if (sc >= 0) {
            sc += " /*= ".length();
        }
        int ec = tostring.lastIndexOf(" */");
        if (sc >= 0 && ec >= 0 && ec > sc && ec < len) {
            return tostring.substring(sc, ec);
        }
        return tostring;
    }

    private void init(JexlBuilder builder) {
        this.BUILDER = builder;
        this.ENGINE = this.BUILDER.create();
        this.JXLT = this.ENGINE.createJxltEngine();
    }

    private boolean isLexicalShade() {
        JexlOptions options = this.context.getEngineOptions();
        if (options.isLexicalShade()) {
            return true;
        }
        options = new JexlOptions().set(this.ENGINE);
        return options.isLexicalShade();
    }

    @Override
    @BeforeEach
    public void setUp() {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
        this.context = new JexlEvalContext((JexlContext)this.vars);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        JXLTTest.debuggerCheck(this.ENGINE);
        super.tearDown();
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311a(JexlBuilder builder) {
        this.init(builder);
        JexlContext ctx = null;
        String rpt = "$$((a)->{\n<p>Universe ${a}</p>\n$$})(42)";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$((a)->{\n<p>Universe ${a}</p>\n$$})(42)"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate(ctx, (Writer)strw);
        String output = strw.toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311b(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        String rpt = "$$ exec('42').execute(()->{\n<p>Universe 42</p>\n$$})";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ exec('42').execute(()->{\n<p>Universe 42</p>\n$$})"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311c(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "$$ exec('42').execute((a)->{\n<p>Universe ${a}</p>\n$$})";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ exec('42').execute((a)->{\n<p>Universe ${a}</p>\n$$})"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311d(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "$$ exec('4').execute((a, b)->{\n<p>Universe ${a}${b}</p>\n$$}, '2')";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ exec('4').execute((a, b)->{\n<p>Universe ${a}${b}</p>\n$$}, '2')"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311e(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "exec('4').execute((a, b)->{ '<p>Universe ' + a + b + '</p>'}, '2')";
        JexlScript script = this.JEXL.createScript("exec('4').execute((a, b)->{ '<p>Universe ' + a + b + '</p>'}, '2')");
        String output = script.execute((JexlContext)ctx311, new Object[]{42}).toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311f(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "exec('4').execute((a, b)->{ `<p>Universe ${a}${b}</p>`}, '2')";
        JexlScript script = this.JEXL.createScript("exec('4').execute((a, b)->{ `<p>Universe ${a}${b}</p>`}, '2')");
        String output = script.execute((JexlContext)ctx311, new Object[]{42}).toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311g(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "(a, b)->{ `<p>Universe ${a}${b}</p>`}";
        JexlScript script = this.JEXL.createScript("(a, b)->{ `<p>Universe ${a}${b}</p>`}");
        String output = script.execute((JexlContext)ctx311, new Object[]{"4", "2"}).toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311h(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = " `<p>Universe ${a}${b}</p>`";
        JexlScript script = this.JEXL.createScript(" `<p>Universe ${a}${b}</p>`", new String[]{"a", "b"});
        String output = script.execute((JexlContext)ctx311, new Object[]{"4", "2"}).toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test311i(JexlBuilder builder) {
        this.init(builder);
        Context311 ctx311 = new Context311();
        String rpt = "$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test315(JexlBuilder builder) {
        this.init(builder);
        String s315 = "<report/>$";
        JxltEngine.Template t315 = this.JXLT.createTemplate("$$", (Reader)new StringReader(s315), new String[0]);
        StringWriter strw = new StringWriter();
        t315.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assertions.assertEquals((Object)s315, (Object)output);
        s315 = "<foo/>#";
        t315 = this.JXLT.createTemplate("$$", (Reader)new StringReader(s315), new String[0]);
        strw = new StringWriter();
        t315.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assertions.assertEquals((Object)s315, (Object)output);
        s315 = "<bar/>\\";
        t315 = this.JXLT.createTemplate("$$", (Reader)new StringReader(s315), new String[0]);
        strw = new StringWriter();
        t315.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assertions.assertEquals((Object)s315, (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void test42(JexlBuilder builder) {
        this.init(builder);
        String test42 = "$$ for (var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ for (var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n"), new String[]{"list"});
        StringWriter strw = new StringWriter();
        int[] list = new int[]{1, 3, 5, 42, 169};
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{list});
        String output = strw.toString();
        String out42 = "The value 1 is under fourty-two\nThe value 3 is under fourty-two\nThe value 5 is under fourty-two\nLife, the universe, and everything\nThe value 169 is over fourty-two\n";
        Assertions.assertEquals((Object)"The value 1 is under fourty-two\nThe value 3 is under fourty-two\nThe value 5 is under fourty-two\nLife, the universe, and everything\nThe value 169 is over fourty-two\n", (Object)output);
        String dstr = t.asString();
        Assertions.assertNotNull((Object)dstr);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = JXLTTest.refactor(td, t);
        Assertions.assertNotNull((Object)refactored);
        Assertions.assertEquals((Object)"$$ for (var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n", (Object)refactored);
    }

    @Test
    void testParseIdentifier() {
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier(null));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)""));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)"za"));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)"a"));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)"00"));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)"01"));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)"001"));
        Assertions.assertNull((Object)JexlArithmetic.parseIdentifier((Object)"12345678901"));
        Assertions.assertEquals((int)0, (Integer)JexlArithmetic.parseIdentifier((Object)"0"));
        Assertions.assertEquals((int)10, (Integer)JexlArithmetic.parseIdentifier((Object)"10"));
        Assertions.assertEquals((int)100, (Integer)JexlArithmetic.parseIdentifier((Object)"100"));
        Assertions.assertEquals((int)42, (Integer)JexlArithmetic.parseIdentifier((Object)"42"));
        Assertions.assertEquals((int)42000, (Integer)JexlArithmetic.parseIdentifier((Object)"42000"));
        Assertions.assertEquals((int)42, (Integer)JexlArithmetic.parseIdentifier((Object)42));
    }

    @Test
    void test425a() {
        String S42 = "fourty-two";
        JexlBuilder builder = new JexlBuilder().strictInterpolation(true);
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("let x = 42; let y = `${x}`; y");
        Object result = script.execute(null);
        Assertions.assertInstanceOf(String.class, (Object)result);
        Assertions.assertEquals((Object)"42", (Object)result);
        Map<String, String> map = Collections.singletonMap("42", "fourty-two");
        script = jexl.createScript("let x = 42; map.`${x}`", new String[]{"map"});
        result = script.execute(null, new Object[]{map});
        Assertions.assertEquals((Object)"fourty-two", (Object)result);
        List<String> list = Collections.singletonList("fourty-two");
        JexlScript finalScript = script;
        Assertions.assertThrows(JexlException.Property.class, () -> finalScript.execute(null, new Object[]{list}));
        script = jexl.createScript("let x = 0; list[x]", new String[]{"list"});
        Assertions.assertEquals((Object)"fourty-two", (Object)result);
    }

    @Test
    void test425b() {
        String S42 = "fourty-two";
        JexlEngine jexl = new JexlBuilder().strictInterpolation(false).create();
        this.run425bc(jexl, false);
        this.run425bc(jexl, false);
    }

    @Test
    void test425c() {
        JexlEngine jexl = new JexlBuilder().cache(8).arithmetic((JexlArithmetic)new Arithmetic425(true)).strictInterpolation(true).create();
        this.run425bc(jexl, true);
        this.run425bc(jexl, true);
    }

    void run425bc(JexlEngine jexl, boolean strictInterpolation) {
        String S42 = "fourty-two";
        JexlScript script = jexl.createScript("let x = 42; let y = `${x}`; y");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)(!strictInterpolation ? Integer.valueOf(42) : "42"), (Object)result);
        Map<Integer, String> map = Collections.singletonMap(0, "fourty-two");
        script = jexl.createScript("let x = 0; map.`${x}`", new String[]{"map"});
        result = script.execute(null, new Object[]{map});
        Assertions.assertEquals((Object)"fourty-two", (Object)result);
        List<String> list = Collections.singletonList("fourty-two");
        result = script.execute(null, new Object[]{list});
        Assertions.assertEquals((Object)"fourty-two", (Object)result);
        map = new HashMap<Integer, String>(map);
        map.put(0, "nothing");
        script = jexl.createScript("let x = 0; map.`${x}` = S42", new String[]{"map", "S42"});
        result = script.execute(null, new Object[]{map, "fourty-two"});
        Assertions.assertEquals((Object)"fourty-two", (Object)result);
        list = new ArrayList<String>(list);
        list.set(0, "nothing");
        result = script.execute(null, new Object[]{map, "fourty-two"});
        Assertions.assertEquals((Object)"fourty-two", (Object)result);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testAssign(JexlBuilder builder) {
        this.init(builder);
        Froboz froboz = new Froboz(32);
        this.context.set("froboz", froboz);
        JxltEngine.Expression assign = this.JXLT.createExpression("${froboz.value = 42}");
        JxltEngine.Expression check = this.JXLT.createExpression("${froboz.value}");
        Object o = assign.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)42, (Object)o);
        o = check.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)42, (Object)o);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testBadContextNested(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Expression expr = this.JXLT.createExpression("#{${hi}+'.world'}");
        JexlContext none = null;
        JxltEngine.Exception xjexl = (JxltEngine.Exception)Assertions.assertThrows(JxltEngine.Exception.class, () -> expr.evaluate(none), (String)"should be malformed");
        LOGGER.debug((Object)xjexl.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testCharAtBug(JexlBuilder builder) {
        this.init(builder);
        this.context.set("foo", "abcdef");
        JexlOptions options = this.context.getEngineOptions();
        JxltEngine.Expression expr = this.JXLT.createExpression("${foo.substring(2,4)/*comment*/}");
        Object o = expr.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)"cd", (Object)o);
        this.context.set("bar", "foo");
        try {
            options.setSilent(true);
            expr = this.JXLT.createExpression("#{${bar}+'.charAt(-2)'}");
            expr = expr.prepare((JexlContext)this.context);
            o = expr.evaluate((JexlContext)this.context);
            Assertions.assertNull((Object)o);
        }
        finally {
            options.setSilent(false);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testCommentedTemplate0(JexlBuilder builder) {
        this.init(builder);
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        String src = "$$/*\nHello\n$$*/";
        JxltEngine.Template tmplt = jxlt.createTemplate("$$/*\nHello\n$$*/");
        Assertions.assertNotNull((Object)tmplt);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        Assertions.assertTrue((boolean)((Object)strw).toString().isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testCommentedTemplate1(JexlBuilder builder) {
        this.init(builder);
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        String src = "$$/*\none\n$$*/\n42\n$$/*\nthree\n$$*/\n";
        JxltEngine.Template tmplt = jxlt.createTemplate("$$/*\none\n$$*/\n42\n$$/*\nthree\n$$*/\n");
        Assertions.assertNotNull((Object)tmplt);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        Assertions.assertEquals((Object)"42\n", (Object)((Object)strw).toString());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testComposite(JexlBuilder builder) {
        this.init(builder);
        String source = "Dear ${p} ${name};";
        JxltEngine.Expression expr = this.JXLT.createExpression("Dear ${p} ${name};");
        this.context.set("p", "Mr");
        this.context.set("name", "Doe");
        Assertions.assertTrue((boolean)expr.isImmediate(), (String)"expression should be immediate");
        Object o = expr.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        this.context.set("p", "Ms");
        this.context.set("name", "Jones");
        o = expr.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)"Dear Ms Jones;", (Object)o);
        Assertions.assertEquals((Object)"Dear ${p} ${name};", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testConstant0(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        String source = "Hello World!";
        JxltEngine.Expression expr = this.JXLT.createExpression("Hello World!");
        Assertions.assertSame((Object)expr.prepare(none), (Object)expr, (String)"prepare should return same expression");
        Object o = expr.evaluate(none);
        Assertions.assertTrue((boolean)expr.isImmediate(), (String)"expression should be immediate");
        Assertions.assertEquals((Object)"Hello World!", (Object)o);
        Assertions.assertEquals((Object)"Hello World!", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testConstant2(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        String source = "${size({'map':123,'map2':456})}";
        JxltEngine.Expression expr = this.JXLT.createExpression("${size({'map':123,'map2':456})}");
        Object o = expr.evaluate(none);
        Assertions.assertTrue((boolean)expr.isImmediate(), (String)"expression should be immediate");
        Assertions.assertEquals((Object)2, (Object)o);
        Assertions.assertEquals((Object)"${size({'map':123,'map2':456})}", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testConstant3(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        String source = "#{size({'map':123,'map2':456})}";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{size({'map':123,'map2':456})}");
        Object o = expr.evaluate(none);
        Assertions.assertTrue((boolean)expr.isDeferred(), (String)"expression should be deferred");
        Assertions.assertEquals((Object)2, (Object)o);
        Assertions.assertEquals((Object)"#{size({'map':123,'map2':456})}", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testConstant4(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        String source = "#{ ${size({'1':2,'2': 3})} }";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{ ${size({'1':2,'2': 3})} }");
        Object o = expr.evaluate(none);
        Assertions.assertTrue((boolean)expr.isDeferred(), (String)"expression should be deferred");
        Assertions.assertEquals((Object)2, (Object)o);
        Assertions.assertEquals((Object)"#{ ${size({'1':2,'2': 3})} }", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testConstantTemplate(JexlBuilder builder) {
        this.init(builder);
        String src = "<script>\n      function test(src){\n        var res = src.replace(/\\n\\t\\s/g, '\\n');\n      }\n      test();\n    </script>";
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template tmplt = jxlt.createTemplate("<script>\n      function test(src){\n        var res = src.replace(/\\n\\t\\s/g, '\\n');\n      }\n      test();\n    </script>");
        Assertions.assertNotNull((Object)tmplt);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        String result = ((Object)strw).toString();
        Assertions.assertEquals((Object)"<script>\n      function test(src){\n        var res = src.replace(/\\n\\t\\s/g, '\\n');\n      }\n      test();\n    </script>", (Object)result);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testDbgEscapes(JexlBuilder builder) {
        String[] srcs;
        this.init(builder);
        for (String src : srcs = new String[]{"jexl:print('hello\\'\\nworld')", "'hello\\tworld'", "'hello\\nworld'", "'hello\\fworld'", "'hello\\rworld'"}) {
            JexlScript script = this.ENGINE.createScript(src);
            Debugger dbg = new Debugger();
            dbg.debug(script);
            String msrc = dbg.toString();
            Assertions.assertEquals((Object)src, (Object)msrc);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testDeferred(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        String source = "#{'world'}";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{'world'}");
        Assertions.assertTrue((boolean)expr.isDeferred(), (String)"expression should be deferred");
        String as = expr.prepare(none).asString();
        Assertions.assertEquals((Object)"${'world'}", (Object)as, (String)"prepare should return immediate version");
        Object o = expr.evaluate(none);
        Assertions.assertEquals((Object)"world", (Object)o);
        Assertions.assertEquals((Object)"#{'world'}", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testEscape(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        JxltEngine.Expression expr = this.JXLT.createExpression("\\#{'world'}");
        Object o = expr.evaluate(none);
        Assertions.assertEquals((Object)"#{'world'}", (Object)o);
        expr = this.JXLT.createExpression("\\${'world'}");
        o = expr.evaluate(none);
        Assertions.assertEquals((Object)"${'world'}", (Object)o);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testEscapeString(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Expression expr = this.JXLT.createExpression("\\\"${'world\\'s finest'}\\\"");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        Assertions.assertEquals((Object)"\"world's finest\"", (Object)o);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testImmediate(JexlBuilder builder) {
        this.init(builder);
        JexlContext none = null;
        String source = "${'Hello ' + 'World!'}";
        JxltEngine.Expression expr = this.JXLT.createExpression("${'Hello ' + 'World!'}");
        JxltEngine.Expression prepared = expr.prepare(none);
        Assertions.assertEquals((Object)"Hello World!", (Object)prepared.asString(), (String)"prepare should return same expression");
        Object o = expr.evaluate(none);
        Assertions.assertTrue((boolean)expr.isImmediate(), (String)"expression should be immediate");
        Assertions.assertEquals((Object)"Hello World!", (Object)o);
        Assertions.assertEquals((Object)"${'Hello ' + 'World!'}", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testImmediateTemplate(JexlBuilder builder) {
        this.init(builder);
        this.context.set("tables", new String[]{"table1", "table2"});
        this.context.set("w", "x=1");
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("select * from \n$$var comma = false; \n$$for(var c : tables) { \n$$  if (comma) $jexl.write(','); else comma = true;\n${c}\n$$}\nwhere ${w}\n"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assertions.assertTrue((output.contains("table1") && output.contains("table2") ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInheritedDebugger(JexlBuilder builder) {
        this.init(builder);
        String src = "if ($A) { $B + 1; } else { $C - 2 }";
        JexlEngine jexl = this.JXLT.getEngine();
        JexlScript script = jexl.createScript("if ($A) { $B + 1; } else { $C - 2 }");
        Debugger sd = new Debugger();
        String rscript = sd.debug(script) ? sd.toString() : null;
        Assertions.assertNotNull((Object)rscript);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = td.debug(script) ? td.toString() : null;
        Assertions.assertNotNull((Object)refactored);
        Assertions.assertEquals((Object)refactored, (Object)rscript);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInterpolation(JexlBuilder builder) {
        this.init(builder);
        String expr = "`Hello \n${user}`";
        JexlScript script = this.ENGINE.createScript("`Hello \n${user}`");
        this.context.set("user", "Dimitri");
        Object value = script.execute((JexlContext)this.context);
        Assertions.assertEquals((Object)"Hello \nDimitri", (Object)value, (String)"`Hello \n${user}`");
        this.context.set("user", "Rahul");
        value = script.execute((JexlContext)this.context);
        Assertions.assertEquals((Object)"Hello \nRahul", (Object)value, (String)"`Hello \n${user}`");
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInterpolationGlobal(JexlBuilder builder) {
        this.init(builder);
        if (this.isLexicalShade()) {
            this.context.set("user", null);
        }
        String expr = "user='Dimitri'; `Hello \n${user}`";
        Object value = this.ENGINE.createScript("user='Dimitri'; `Hello \n${user}`").execute((JexlContext)this.context);
        Assertions.assertEquals((Object)"Hello \nDimitri", (Object)value, (String)"user='Dimitri'; `Hello \n${user}`");
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInterpolationLocal(JexlBuilder builder) {
        this.init(builder);
        String expr = "var user='Henrib'; `Hello \n${user}`";
        Object value = this.ENGINE.createScript("var user='Henrib'; `Hello \n${user}`").execute((JexlContext)this.context);
        Assertions.assertEquals((Object)"Hello \nHenrib", (Object)value, (String)"var user='Henrib'; `Hello \n${user}`");
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInterpolationLvsG(JexlBuilder builder) {
        this.init(builder);
        if (this.isLexicalShade()) {
            this.context.set("user", null);
        }
        String expr = "user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`";
        Object value = this.ENGINE.createScript("user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`").execute((JexlContext)this.context);
        Assertions.assertEquals((Object)"H\"ello \nHenrib", (Object)value, (String)"user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`");
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInterpolationLvsG2(JexlBuilder builder) {
        this.init(builder);
        if (this.isLexicalShade()) {
            this.context.set("user", null);
        }
        String expr = "user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`";
        Object value = this.ENGINE.createScript("user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`").execute((JexlContext)this.context);
        Assertions.assertEquals((Object)"H`ello \nHenrib", (Object)value, (String)"user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`");
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testInterpolationParameter(JexlBuilder builder) {
        this.init(builder);
        String expr = "(user)->{`Hello \n${user}`}";
        JexlScript script = this.ENGINE.createScript("(user)->{`Hello \n${user}`}");
        Object value = script.execute((JexlContext)this.context, new Object[]{"Henrib"});
        Assertions.assertEquals((Object)"Hello \nHenrib", (Object)value, (String)"(user)->{`Hello \n${user}`}");
        value = this.ENGINE.createScript("(user)->{`Hello \n${user}`}").execute((JexlContext)this.context, new Object[]{"Dimitri"});
        Assertions.assertEquals((Object)"Hello \nDimitri", (Object)value, (String)"(user)->{`Hello \n${user}`}");
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testLexicalTemplate(JexlBuilder builder) {
        this.init(builder);
        JexlOptions opts = new JexlOptions();
        JexlTestCase.PragmaticContext ctxt = new JexlTestCase.PragmaticContext(opts);
        opts.setCancellable(false);
        opts.setStrict(false);
        opts.setSafe(true);
        opts.setLexical(false);
        opts.setLexicalShade(false);
        String src0 = "${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe";
        JxltEngine.Template tmplt0 = this.JXLT.createTemplate("$$", (Reader)new StringReader("${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe"), new String[0]);
        StringWriter strw0 = new StringWriter();
        tmplt0.evaluate((JexlContext)ctxt, (Writer)strw0);
        String output0 = ((Object)strw0).toString();
        JexlFeatures features = this.BUILDER.features();
        if (features != null && features.isLexical() && features.isLexicalShade()) {
            Assertions.assertEquals((Object)"-strict -cancellable +lexical +lexicalShade +safe", (Object)output0);
        } else {
            Assertions.assertEquals((Object)"-strict -cancellable -lexical -lexicalShade +safe", (Object)output0);
        }
        String src = "$$ #pragma script.mode pro50\n${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe";
        JxltEngine.Template tmplt = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ #pragma script.mode pro50\n${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe"), new String[0]);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = ((Object)strw).toString();
        Assertions.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -safe", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testMalformed(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Exception xjexl = (JxltEngine.Exception)Assertions.assertThrows(JxltEngine.Exception.class, () -> this.JXLT.createExpression("${'world'"), (String)"should be malformed");
        LOGGER.debug((Object)xjexl.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testMalformedNested(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Exception xjexl = (JxltEngine.Exception)Assertions.assertThrows(JxltEngine.Exception.class, () -> this.JXLT.createExpression("#{${hi} world}"), (String)"should be malformed");
        LOGGER.debug((Object)xjexl.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testMalformedNested2(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Exception xjexl = (JxltEngine.Exception)Assertions.assertThrows(JxltEngine.Exception.class, () -> this.JXLT.createExpression("#{${hi} world}"), (String)"should be malformed");
        LOGGER.debug((Object)xjexl.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testNested(JexlBuilder builder) {
        this.init(builder);
        String source = "#{${hi}+'.world'}";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{${hi}+'.world'}");
        Set evars = expr.getVariables();
        Assertions.assertEquals((int)1, (int)evars.size());
        Assertions.assertTrue((boolean)this.contains(evars, Collections.singletonList("hi")));
        this.context.set("hi", "greeting");
        this.context.set("greeting.world", "Hello World!");
        Assertions.assertTrue((boolean)expr.isDeferred(), (String)"expression should be deferred");
        Object o = expr.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)"Hello World!", (Object)o);
        Assertions.assertEquals((Object)"#{${hi}+'.world'}", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testNestedTemplate(JexlBuilder builder) {
        this.init(builder);
        String source = "#{${hi}+'.world'}";
        JxltEngine.Template expr = this.JXLT.createTemplate("#{${hi}+'.world'}", new String[]{"hi"});
        this.context.set("greeting.world", "Hello World!");
        StringWriter strw = new StringWriter();
        expr.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{"greeting"});
        String o = strw.toString();
        Assertions.assertEquals((Object)"Hello World!", (Object)o);
        Assertions.assertEquals((Object)"#{${hi}+'.world'}", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testNonEscapeString(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Expression expr = this.JXLT.createExpression("c:\\some\\windows\\path");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        Assertions.assertEquals((Object)"c:\\some\\windows\\path", (Object)o);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testOneLiner(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("fourty-two"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assertions.assertEquals((Object)"fourty-two", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testOneLinerVar(JexlBuilder builder) {
        this.init(builder);
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("fourty-${x}"), new String[0]);
        StringWriter strw = new StringWriter();
        this.context.set("x", "two");
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assertions.assertEquals((Object)"fourty-two", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testPrepareEvaluate(JexlBuilder builder) {
        this.init(builder);
        String source = "Dear #{p} ${name};";
        JxltEngine.Expression expr = this.JXLT.createExpression("Dear #{p} ${name};");
        Assertions.assertTrue((boolean)expr.isDeferred(), (String)"expression should be deferred");
        Set evars = expr.getVariables();
        Assertions.assertEquals((int)1, (int)evars.size());
        Assertions.assertTrue((boolean)this.contains(evars, Collections.singletonList("name")));
        this.context.set("name", "Doe");
        JxltEngine.Expression phase1 = expr.prepare((JexlContext)this.context);
        String as = phase1.asString();
        Assertions.assertEquals((Object)"Dear ${p} Doe;", (Object)as);
        Set evars1 = phase1.getVariables();
        Assertions.assertEquals((int)1, (int)evars1.size());
        Assertions.assertTrue((boolean)this.contains(evars1, Collections.singletonList("p")));
        this.vars.clear();
        this.context.set("p", "Mr");
        this.context.set("name", "Should not be used in 2nd phase");
        Object o = phase1.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        String p1 = this.getSource(phase1.toString());
        Assertions.assertEquals((Object)"Dear #{p} ${name};", (Object)this.getSource(phase1.toString()));
        Assertions.assertEquals((Object)"Dear #{p} ${name};", (Object)this.getSource(expr.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testPrepareTemplate(JexlBuilder builder) {
        this.init(builder);
        String source = "$$ for(var x : list) {\n${l10n}=#{x}\n$$ }\n";
        int[] args = new int[]{42};
        JxltEngine.Template tl10n = this.JXLT.createTemplate("$$ for(var x : list) {\n${l10n}=#{x}\n$$ }\n", new String[]{"list"});
        String dstr = tl10n.asString();
        Assertions.assertNotNull((Object)dstr);
        Set vars = tl10n.getVariables();
        Assertions.assertFalse((boolean)vars.isEmpty());
        this.context.set("l10n", "valeur");
        JxltEngine.Template tpFR = tl10n.prepare((JexlContext)this.context);
        this.context.set("l10n", "value");
        JxltEngine.Template tpEN = tl10n.prepare((JexlContext)this.context);
        this.context.set("l10n", null);
        StringWriter strw = new StringWriter();
        tpFR.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{args});
        String outFR = strw.toString();
        Assertions.assertEquals((Object)"valeur=42\n", (Object)outFR);
        this.context.set("l10n", null);
        strw = new StringWriter();
        tpEN.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{args});
        String outEN = strw.toString();
        Assertions.assertEquals((Object)"value=42\n", (Object)outEN);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testReport(JexlBuilder builder) {
        this.init(builder);
        String rpt = "<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        String ctl = "<report>\n\n\n\n\n        11\n</report>\n";
        Assertions.assertEquals((Object)"<report>\n\n\n\n\n        11\n</report>\n", (Object)output);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = JXLTTest.refactor(td, t);
        Assertions.assertNotNull((Object)refactored);
        Assertions.assertEquals((Object)"<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n", (Object)refactored);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testReport1(JexlBuilder builder) {
        this.init(builder);
        String rpt = "<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n"), new String[0]);
        StringWriter strw = new StringWriter();
        this.context.set("x", 42);
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        int count = 0;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if ('\n' != c) continue;
            ++count;
        }
        Assertions.assertEquals((int)6, (int)count);
        Assertions.assertTrue((output.indexOf("42") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((output.indexOf("43") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((output.indexOf("44") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((output.indexOf("45") > 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testReport2(JexlBuilder builder) {
        this.init(builder);
        String rpt = "<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n"), new String[]{"x"});
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        int count = 0;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if ('\n' != c) continue;
            ++count;
        }
        Assertions.assertEquals((int)6, (int)count);
        Assertions.assertTrue((output.indexOf("42") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((output.indexOf("43") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((output.indexOf("44") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((output.indexOf("45") > 0 ? 1 : 0) != 0);
        TemplateDebugger td = new TemplateDebugger();
        String xxx = JXLTTest.refactor(td, t);
        Assertions.assertNotNull((Object)xxx);
        Assertions.assertEquals((Object)"<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n", (Object)xxx);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testSanboxed311i(JexlBuilder builder) {
        this.init(builder);
        Uberspect uberspect = new Uberspect(LogFactory.getLog(JXLTTest.class), null, (JexlPermissions)NOJEXL3);
        Method method = uberspect.getMethod(TemplateInterpreter.class, "print", new Object[]{Integer.TYPE});
        JexlEngine jexl = new JexlBuilder().uberspect((JexlUberspect)uberspect).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        Context311 ctx311 = new Context311();
        String rpt = "$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')";
        JxltEngine.Template t = jxlt.createTemplate("$$", (Reader)new StringReader("$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testSanboxedTemplate(JexlBuilder builder) {
        this.init(builder);
        String src = "Hello ${user}";
        MapContext ctxt = new MapContext();
        ctxt.set("user", (Object)"Francesco");
        Uberspect uberspect = new Uberspect(LogFactory.getLog(JXLTTest.class), null, (JexlPermissions)NOJEXL3);
        Method method = uberspect.getMethod(TemplateInterpreter.class, "print", new Object[]{Integer.TYPE});
        Assertions.assertNull((Object)method);
        JexlEngine jexl = new JexlBuilder().uberspect((JexlUberspect)uberspect).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template tmplt = jxlt.createTemplate("Hello ${user}");
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        String result = ((Object)strw).toString();
        Assertions.assertEquals((Object)"Hello Francesco", (Object)result);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testStatement(JexlBuilder builder) {
        this.init(builder);
        Froboz froboz = new Froboz(32);
        this.context.set("froboz", froboz);
        JxltEngine.Expression check = this.JXLT.createExpression("${ froboz.plus10() }");
        Object o = check.evaluate((JexlContext)this.context);
        Assertions.assertEquals((Object)32, (Object)o);
        Assertions.assertEquals((int)42, (int)froboz.getValue());
        Set evars = check.getVariables();
        Assertions.assertEquals((int)1, (int)evars.size());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testTemplate0(JexlBuilder builder) {
        this.init(builder);
        String source = "   $$ if(x) {\nx is ${x}\n   $$ } else {\n${'no x'}\n$$ }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("   $$ if(x) {\nx is ${x}\n   $$ } else {\n${'no x'}\n$$ }\n");
        this.context.set("x", 42);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assertions.assertEquals((Object)"x is 42\n", (Object)output);
        strw = new StringWriter();
        this.context.set("x", "");
        t.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assertions.assertEquals((Object)"no x\n", (Object)output);
        String dstr = t.toString();
        Assertions.assertNotNull((Object)dstr);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testTemplate1(JexlBuilder builder) {
        this.init(builder);
        String source = "$$ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ }\n"), new String[]{"x"});
        String dstr = t.asString();
        Assertions.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"x is 42\n", (Object)output);
        strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{""});
        output = strw.toString();
        Assertions.assertEquals((Object)"no x\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testTemplate10(JexlBuilder builder) {
        this.init(builder);
        String source = "$$(x)->{ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ } }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$(x)->{ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ } }\n"), (String[])null);
        String dstr = t.asString();
        Assertions.assertNotNull((Object)dstr);
        String[] ps = t.getParameters();
        Assertions.assertTrue((boolean)Arrays.asList(ps).contains("x"));
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"x is 42\n", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testTemplate2(JexlBuilder builder) {
        this.init(builder);
        String source = "The answer: ${x}";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("The answer: ${x}"), new String[]{"x"});
        String dstr = t.asString();
        Assertions.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assertions.assertEquals((Object)"The answer: 42", (Object)output);
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testTemplateOutOfScope(JexlBuilder builder) {
        JxltEngine.Template tmplt;
        this.init(builder);
        JexlOptions opts = new JexlOptions();
        opts.setCancellable(false);
        opts.setStrict(false);
        opts.setLexical(false);
        opts.setLexicalShade(false);
        opts.setSharedInstance(true);
        JexlTestCase.PragmaticContext ctxt = new JexlTestCase.PragmaticContext(opts);
        String src = "$$if (false) { var tab = 42; }\n${tab}";
        JexlFeatures features = this.BUILDER.features();
        try {
            tmplt = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$if (false) { var tab = 42; }\n${tab}"), new String[0]);
        }
        catch (JexlException xparse) {
            if (features != null && features.isLexicalShade()) {
                return;
            }
            throw xparse;
        }
        StringWriter strw = new StringWriter();
        opts.setSafe(true);
        Assertions.assertDoesNotThrow(() -> JXLTTest.lambda$testTemplateOutOfScope$5(tmplt, (JexlContext)ctxt, strw), (String)"safe should prevent local shade");
        Assertions.assertTrue((boolean)((Object)strw).toString().isEmpty());
        opts.setStrict(true);
        opts.setSafe(false);
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> JXLTTest.lambda$testTemplateOutOfScope$6(tmplt, (JexlContext)ctxt, strw));
        Assertions.assertTrue((boolean)"tab".equals(xvar.getVariable()));
        Assertions.assertTrue((boolean)xvar.isUndefined());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testTemplatePragmaPro50(JexlBuilder builder) {
        this.init(builder);
        JexlOptions opts = new JexlOptions();
        opts.setCancellable(false);
        opts.setStrict(false);
        opts.setSafe(true);
        opts.setLexical(false);
        opts.setLexicalShade(false);
        opts.setSharedInstance(true);
        JexlTestCase.PragmaticContext ctxt = new JexlTestCase.PragmaticContext(opts);
        String src = "$$ #pragma script.mode pro50\n$$ var tab = null;\n$$ tab.dummy();";
        JxltEngine.Template tmplt = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ #pragma script.mode pro50\n$$ var tab = null;\n$$ tab.dummy();"), new String[0]);
        StringWriter strw = new StringWriter();
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> JXLTTest.lambda$testTemplatePragmaPro50$7(tmplt, (JexlContext)ctxt, strw));
        Assertions.assertEquals((Object)"tab", (Object)xvar.getVariable());
        Assertions.assertFalse((boolean)xvar.isUndefined());
    }

    @ParameterizedTest
    @MethodSource(value={"engines"})
    void testWriter(JexlBuilder builder) {
        this.init(builder);
        Froboz froboz = new Froboz(42);
        FrobozWriter writer = new FrobozWriter(new StringWriter());
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$$jexl.print(froboz)"), new String[]{"froboz"});
        t.evaluate((JexlContext)this.context, (Writer)writer, new Object[]{froboz});
        Assertions.assertEquals((Object)"froboz{42}", (Object)((Object)writer).toString());
    }

    private static /* synthetic */ void lambda$testTemplatePragmaPro50$7(JxltEngine.Template tmplt, JexlContext ctxt, Writer strw) throws Throwable {
        tmplt.evaluate(ctxt, strw);
    }

    private static /* synthetic */ void lambda$testTemplateOutOfScope$6(JxltEngine.Template tmplt, JexlContext ctxt, Writer strw) throws Throwable {
        tmplt.evaluate(ctxt, strw);
    }

    private static /* synthetic */ void lambda$testTemplateOutOfScope$5(JxltEngine.Template tmplt, JexlContext ctxt, Writer strw) throws Throwable {
        tmplt.evaluate(ctxt, strw);
    }

    public static class Context311
    extends MapContext
    implements JexlContext.OptionsHandle,
    JexlContext.ThreadLocal {
        private JexlOptions options;

        public Executor311 exec(String name) {
            return new Executor311(name);
        }

        public JexlOptions getEngineOptions() {
            return this.options;
        }

        JexlOptions newOptions() {
            this.options = new JexlOptions();
            return this.options;
        }

        public void setOptions(JexlOptions o) {
            this.options = o;
        }
    }

    public static class Arithmetic425
    extends JexlArithmetic {
        public Arithmetic425(boolean astrict) {
            super(astrict);
        }

        public Object propertyGet(List list, String property) {
            Integer id = JexlArithmetic.parseIdentifier((Object)property);
            return id == null ? JexlEngine.TRY_FAILED : list.get(id);
        }

        public Object propertySet(List list, String property, Object value) {
            Integer id = JexlArithmetic.parseIdentifier((Object)property);
            if (id != null) {
                return list.set(id, value);
            }
            return JexlEngine.TRY_FAILED;
        }

        public Object propertyGet(Map list, String property) {
            Integer id;
            if (list.keySet().stream().findFirst().orElse(null) instanceof Number && (id = JexlArithmetic.parseIdentifier((Object)property)) != null) {
                return list.get(id);
            }
            return JexlEngine.TRY_FAILED;
        }

        public Object propertySet(Map list, String property, Object value) {
            Integer id;
            if (list.keySet().stream().findFirst().orElse(null) instanceof Number && (id = JexlArithmetic.parseIdentifier((Object)property)) != null) {
                list.put(id, value);
                return value;
            }
            return JexlEngine.TRY_FAILED;
        }
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public int plus10() {
            int i = this.value;
            this.value += 10;
            return i;
        }

        public void setValue(int v) {
            this.value = v;
        }
    }

    public static class FrobozWriter
    extends PrintWriter {
        public FrobozWriter(Writer w) {
            super(w);
        }

        public void print(Froboz froboz) {
            super.print("froboz{");
            super.print(froboz.value);
            super.print("}");
        }

        public String toString() {
            return this.out.toString();
        }
    }

    public static class Executor311 {
        private final String name;

        public Executor311(String name) {
            this.name = name;
        }

        public Object execute(JexlScript script, Object ... args) {
            Object[] actuals;
            if (args != null && args.length > 0) {
                actuals = new Object[args.length + 1];
                System.arraycopy(args, 0, actuals, 1, args.length);
                actuals[0] = this.name;
            } else {
                actuals = new Object[]{this.name};
            }
            return script.execute((JexlContext)JexlEngine.getThreadContext(), actuals);
        }
    }
}

