/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.utils.DefaultLog;

public final class DocumentName
implements Comparable<DocumentName> {
    public static final boolean FS_IS_CASE_SENSITIVE;
    private final String name;
    private final String baseName;
    private final String dirSeparator;
    private final boolean isCaseSensitive;

    public DocumentName(String name, String baseName, String dirSeparator, boolean isCaseSensitive) {
        this.name = Objects.requireNonNull(name);
        this.baseName = Objects.requireNonNull(StringUtils.defaultIfEmpty(baseName, null));
        this.dirSeparator = Objects.requireNonNull(dirSeparator);
        this.isCaseSensitive = isCaseSensitive;
    }

    public DocumentName(File file, DocumentName baseName) {
        this(file.getAbsolutePath(), baseName.baseName, File.separator, FS_IS_CASE_SENSITIVE);
    }

    public DocumentName(File file) {
        this(file.getAbsolutePath(), file.getAbsolutePath(), File.separator, FS_IS_CASE_SENSITIVE);
    }

    public DocumentName resolve(String child) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.addAll(Arrays.asList(this.tokenize(this.name)));
        parts.addAll(Arrays.asList(this.tokenize(child)));
        String newName = String.join((CharSequence)this.dirSeparator, parts);
        return new DocumentName(newName, this.baseName, this.dirSeparator, this.isCaseSensitive);
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public DocumentName getBaseDocumentName() {
        return this.name.equals(this.baseName) ? this : new DocumentName(this.baseName, this.baseName, this.dirSeparator, this.isCaseSensitive);
    }

    public String getDirectorySeparator() {
        return this.dirSeparator;
    }

    public String localized() {
        String result = this.name;
        if (result.startsWith(this.baseName)) {
            result = result.substring(this.baseName.length());
        }
        if (!result.startsWith(this.dirSeparator)) {
            result = this.dirSeparator + result;
        }
        return result;
    }

    public String localized(String dirSeparator) {
        return String.join((CharSequence)dirSeparator, this.tokenize(this.localized()));
    }

    public String[] tokenize(String source) {
        return source.split("\\Q" + this.dirSeparator + "\\E");
    }

    public String getShortName() {
        int pos = this.name.lastIndexOf(this.dirSeparator);
        return pos == -1 ? this.name : this.name.substring(pos + 1);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public String toString() {
        return this.localized();
    }

    @Override
    public int compareTo(DocumentName o) {
        return FS_IS_CASE_SENSITIVE ? this.name.compareTo(o.name) : this.name.compareToIgnoreCase(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentName that = (DocumentName)o;
        if (this.isCaseSensitive() == that.isCaseSensitive() && Objects.equals(this.dirSeparator, that.dirSeparator)) {
            return this.isCaseSensitive ? this.name.equalsIgnoreCase(that.name) : this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dirSeparator, this.isCaseSensitive());
    }

    /*
     * Unable to fully structure code
     */
    static {
        fsSensitive = true;
        f = null;
        try {
            p = Files.createTempDirectory("NameSet", new FileAttribute[0]);
            f = p.toFile();
            v0 = fsSensitive = new File(f, "a").equals(new File(f, "A")) == false;
            ** if (f == null) goto lbl-1000
        }
        catch (IOException e) {
            try {
                fsSensitive = true;
                ** if (f == null) goto lbl-1000
            }
            catch (Throwable var3_6) {
                if (f != null) {
                    try {
                        FileUtils.deleteDirectory(f);
                    }
                    catch (IOException e) {
                        DefaultLog.getInstance().warn("Unable to delete temporary directory: " + f, e);
                    }
                }
                throw var3_6;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    FileUtils.deleteDirectory(f);
                }
                catch (IOException e) {
                    DefaultLog.getInstance().warn("Unable to delete temporary directory: " + f, e);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                FileUtils.deleteDirectory(f);
            }
            catch (IOException e) {
                DefaultLog.getInstance().warn("Unable to delete temporary directory: " + f, e);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        DocumentName.FS_IS_CASE_SENSITIVE = fsSensitive;
    }
}

