/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.guava32.com.google.common.primitives.Primitives;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Deprecated
@Internal
public class LegacyUserDefinedFunctionInference {
    public static InputTypeStrategy getInputTypeStrategy(final ImperativeAggregateFunction<?, ?> func) {
        return new InputTypeStrategy(){

            @Override
            public ArgumentCount getArgumentCount() {
                return ConstantArgumentCount.any();
            }

            @Override
            public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
                List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
                DataType accType = LegacyUserDefinedFunctionInference.getAccumulatorType(func);
                LogicalType[] input = (LogicalType[])Stream.concat(Stream.of(accType), argumentDataTypes.stream()).map(DataType::getLogicalType).toArray(LogicalType[]::new);
                Optional<Optional> foundMethod = Stream.of(LegacyUserDefinedFunctionInference.logicalTypesToInternalClasses(input), LegacyUserDefinedFunctionInference.logicalTypesToExternalClasses(input)).map(signature -> LegacyUserDefinedFunctionInference.getUserDefinedMethod(func, "accumulate", signature, input, cls -> (DataType[])Stream.concat(Stream.of(accType), Arrays.stream(cls).skip(1L).map(c -> TypeConversions.fromLegacyInfoToDataType(TypeExtractor.createTypeInfo((Class)c)))).toArray(DataType[]::new))).filter(Optional::isPresent).findAny();
                if (foundMethod.isPresent()) {
                    return Optional.of(argumentDataTypes);
                }
                return callContext.fail(throwOnFailure, "", new Object[0]);
            }

            @Override
            public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
                return LegacyUserDefinedFunctionInference.getSignatures(func, "accumulate");
            }
        };
    }

    public static InputTypeStrategy getInputTypeStrategy(final TableFunction<?> func) {
        return new InputTypeStrategy(){

            @Override
            public ArgumentCount getArgumentCount() {
                return ConstantArgumentCount.any();
            }

            @Override
            public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
                List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
                LogicalType[] input = (LogicalType[])argumentDataTypes.stream().map(DataType::getLogicalType).toArray(LogicalType[]::new);
                Optional<Method> foundMethod = LegacyUserDefinedFunctionInference.getUserDefinedMethod(func, "eval", (Class[])argumentDataTypes.stream().map(DataType::getConversionClass).toArray(Class[]::new), input, cls -> (DataType[])Arrays.stream(cls).map(c -> TypeConversions.fromLegacyInfoToDataType(TypeExtractor.createTypeInfo((Class)c))).toArray(DataType[]::new));
                if (foundMethod.isPresent()) {
                    return Optional.of(argumentDataTypes);
                }
                return callContext.fail(throwOnFailure, "Given parameters do not match any signature.", new Object[0]);
            }

            @Override
            public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
                return LegacyUserDefinedFunctionInference.getSignatures(func, "eval");
            }
        };
    }

    public static TypeStrategy getOutputTypeStrategy(ScalarFunction func) {
        return callContext -> {
            LogicalType[] params = (LogicalType[])callContext.getArgumentDataTypes().stream().map(DataType::getLogicalType).toArray(LogicalType[]::new);
            Optional<Class<?>[]> evalParams = LegacyUserDefinedFunctionInference.getEvalMethodSignature(func, params);
            if (!evalParams.isPresent()) {
                return Optional.empty();
            }
            TypeInformation<?> userDefinedTypeInfo = func.getResultType(evalParams.get());
            if (userDefinedTypeInfo != null) {
                return Optional.of(TypeConversions.fromLegacyInfoToDataType(userDefinedTypeInfo));
            }
            Optional<Method> eval = LegacyUserDefinedFunctionInference.getUserDefinedMethod(func, "eval", LegacyUserDefinedFunctionInference.logicalTypesToExternalClasses(params), params, paraClasses -> (DataType[])Arrays.stream(func.getParameterTypes((Class<?>[])paraClasses)).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new));
            return eval.flatMap(m -> TypeConversions.fromClassToDataType(m.getReturnType()));
        };
    }

    public static InputTypeStrategy getInputTypeStrategy(final ScalarFunction func) {
        return new InputTypeStrategy(){

            @Override
            public ArgumentCount getArgumentCount() {
                return ConstantArgumentCount.any();
            }

            @Override
            public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
                List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
                LogicalType[] input = (LogicalType[])argumentDataTypes.stream().map(DataType::getLogicalType).toArray(LogicalType[]::new);
                Optional<Method> foundMethod = LegacyUserDefinedFunctionInference.getUserDefinedMethod(func, "eval", LegacyUserDefinedFunctionInference.logicalTypesToExternalClasses(input), input, paraClasses -> (DataType[])Arrays.stream(func.getParameterTypes((Class<?>[])paraClasses)).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new));
                if (foundMethod.isPresent()) {
                    return Optional.of(argumentDataTypes);
                }
                return callContext.fail(throwOnFailure, "Given parameters do not match any signature.", new Object[0]);
            }

            @Override
            public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
                return LegacyUserDefinedFunctionInference.getSignatures(func, "eval");
            }
        };
    }

    private static Optional<Class<?>[]> getEvalMethodSignature(ScalarFunction func, LogicalType[] expectedTypes) {
        return LegacyUserDefinedFunctionInference.getUserDefinedMethod(func, "eval", LegacyUserDefinedFunctionInference.logicalTypesToExternalClasses(expectedTypes), expectedTypes, paraClasses -> (DataType[])Arrays.stream(func.getParameterTypes((Class<?>[])paraClasses)).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new)).map(m -> LegacyUserDefinedFunctionInference.getParamClassesConsiderVarArgs(m.isVarArgs(), m.getParameterTypes(), expectedTypes.length));
    }

    private static Class<?>[] getParamClassesConsiderVarArgs(boolean isVarArgs, Class<?>[] matchingSignature, int expectedLength) {
        return (Class[])IntStream.range(0, expectedLength).mapToObj(i -> {
            if (i < matchingSignature.length - 1) {
                return matchingSignature[i];
            }
            if (isVarArgs) {
                return matchingSignature[matchingSignature.length - 1].getComponentType();
            }
            return matchingSignature[matchingSignature.length - 1];
        }).toArray(Class[]::new);
    }

    private static DataType getAccumulatorType(ImperativeAggregateFunction<?, ?> func) {
        TypeInformation<?> accType = func.getAccumulatorType();
        if (accType != null) {
            return TypeConversions.fromLegacyInfoToDataType(accType);
        }
        try {
            return TypeConversions.fromLegacyInfoToDataType(TypeExtractor.createTypeInfo(func, ImperativeAggregateFunction.class, func.getClass(), (int)1));
        }
        catch (InvalidTypesException ite) {
            throw new TableException(String.format("Cannot infer generic type of %s}. You can override ImperativeAggregateFunction.getAccumulatorType() to specify the type.", func.getClass()), ite);
        }
    }

    private static Class<?>[] logicalTypesToExternalClasses(LogicalType[] types) {
        return (Class[])Arrays.stream(types).map(t -> {
            if (t == null) {
                return null;
            }
            return TypeConversions.fromLogicalToDataType(t).getConversionClass();
        }).toArray(Class[]::new);
    }

    private static Class<?>[] logicalTypesToInternalClasses(LogicalType[] types) {
        return (Class[])Arrays.stream(types).map(t -> {
            if (t == null) {
                return null;
            }
            return LogicalTypeUtils.toInternalConversionClass(t);
        }).toArray(Class[]::new);
    }

    private static boolean parameterClassEquals(Class<?> candidate, Class<?> expected) {
        return candidate == null || candidate == expected || expected == Object.class || candidate == Object.class || expected.isPrimitive() && Primitives.wrap(expected) == candidate || candidate == Date.class && (expected == Integer.class || expected == Integer.TYPE) || candidate == Time.class && (expected == Integer.class || expected == Integer.TYPE) || candidate == StringData.class && expected == String.class || candidate == String.class && expected == StringData.class || candidate == TimestampData.class && expected == LocalDateTime.class || candidate == Timestamp.class && expected == TimestampData.class || candidate == TimestampData.class && expected == Timestamp.class || candidate == LocalDateTime.class && expected == TimestampData.class || candidate == TimestampData.class && expected == Instant.class || candidate == Instant.class && expected == TimestampData.class || RowData.class.isAssignableFrom(candidate) && expected == Row.class || candidate == Row.class && RowData.class.isAssignableFrom(expected) || RowData.class.isAssignableFrom(candidate) && expected == RowData.class || candidate == RowData.class && RowData.class.isAssignableFrom(expected) || candidate == DecimalData.class && expected == BigDecimal.class || candidate == BigDecimal.class && expected == DecimalData.class || candidate.isArray() && expected.isArray() && candidate.getComponentType() != null && expected.getComponentType() == Object.class;
    }

    private static boolean parameterDataTypeEquals(LogicalType internal, DataType parameterType) {
        if (internal.is(LogicalTypeRoot.RAW) && parameterType.getLogicalType().is(LogicalTypeRoot.RAW)) {
            return TypeConversions.fromLogicalToDataType(internal).getConversionClass() == parameterType.getConversionClass();
        }
        return parameterType.getLogicalType() == internal || LogicalTypeUtils.toInternalConversionClass(internal) == LogicalTypeUtils.toInternalConversionClass(parameterType.getLogicalType());
    }

    private static Optional<Method> getUserDefinedMethod(UserDefinedFunction function, String methodName, Class<?>[] methodSignature, LogicalType[] internalTypes, Function<Class<?>[], DataType[]> parameterTypesFunc) {
        List<Method> methods = LegacyUserDefinedFunctionInference.checkAndExtractMethods(function, methodName);
        List filteredMethods = methods.stream().filter(cur -> {
            Class<?>[] parameterTypes = cur.getParameterTypes();
            DataType[] parameterDataTypes = (DataType[])parameterTypesFunc.apply(parameterTypes);
            if (cur.isVarArgs()) {
                return LegacyUserDefinedFunctionInference.varArgsMethodMatch(methodSignature, internalTypes, parameterTypes, parameterDataTypes);
            }
            return LegacyUserDefinedFunctionInference.methodMatch(methodSignature, internalTypes, parameterTypes, parameterDataTypes);
        }).collect(Collectors.toList());
        List found = filteredMethods.stream().sorted(Comparator.comparing(Method::isVarArgs, Boolean::compareTo)).filter(cur -> !Modifier.isVolatile(cur.getModifiers())).collect(Collectors.toList());
        int foundCount = found.size();
        if (foundCount == 1) {
            return Optional.of((Method)found.get(0));
        }
        if (foundCount > 1) {
            if (Arrays.asList(methodSignature).contains(Object.class)) {
                return Optional.of((Method)found.get(0));
            }
            List nonObjectParameterMethods = found.stream().filter(m -> !Arrays.asList(m.getParameterTypes()).contains(Object.class)).collect(Collectors.toList());
            if (nonObjectParameterMethods.size() == 1) {
                return Optional.of((Method)nonObjectParameterMethods.get(0));
            }
            throw new ValidationException(String.format("Found multiple '%s' methods which match the signature.", methodName));
        }
        return Optional.empty();
    }

    private static boolean methodMatch(Class<?>[] methodSignature, LogicalType[] internalTypes, Class<?>[] parameterTypes, DataType[] parameterDataTypes) {
        return methodSignature.length == parameterTypes.length && IntStream.range(0, parameterTypes.length).allMatch(i -> LegacyUserDefinedFunctionInference.parameterClassEquals(methodSignature[i], parameterTypes[i]) || LegacyUserDefinedFunctionInference.parameterDataTypeEquals(internalTypes[i], parameterDataTypes[i]));
    }

    private static boolean varArgsMethodMatch(Class<?>[] methodSignature, LogicalType[] internalTypes, Class<?>[] parameterTypes, DataType[] parameterDataTypes) {
        if (methodSignature.length == 0 && parameterTypes.length == 1) {
            return true;
        }
        return IntStream.range(0, methodSignature.length).allMatch(i -> {
            if (i < parameterTypes.length - 1) {
                return LegacyUserDefinedFunctionInference.parameterClassEquals(methodSignature[i], parameterTypes[i]) || LegacyUserDefinedFunctionInference.parameterDataTypeEquals(internalTypes[i], parameterDataTypes[i]);
            }
            return LegacyUserDefinedFunctionInference.parameterClassEquals(methodSignature[i], parameterTypes[parameterTypes.length - 1].getComponentType()) || LegacyUserDefinedFunctionInference.parameterDataTypeEquals(internalTypes[i], parameterDataTypes[i]);
        });
    }

    private static List<Method> checkAndExtractMethods(UserDefinedFunction function, String methodName) {
        List<Method> methods = Arrays.stream(function.getClass().getMethods()).filter(m -> {
            int modifiers = m.getModifiers();
            return m.getName().equals(methodName) && Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && (!(function instanceof TableFunction) || !Modifier.isStatic(modifiers));
        }).collect(Collectors.toList());
        if (methods.isEmpty()) {
            throw new ValidationException(String.format("Function class '%s' does not implement at least one method named '%s' which is public, not abstract and (in case of table functions) not static.", function.getClass().getCanonicalName(), methodName));
        }
        return methods;
    }

    private static List<Signature> getSignatures(UserDefinedFunction func, String methodName) {
        return LegacyUserDefinedFunctionInference.checkAndExtractMethods(func, methodName).stream().map(Method::getParameterTypes).map(sig -> Signature.of(Arrays.stream(sig).map(s -> Signature.Argument.of(s.getSimpleName())).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private LegacyUserDefinedFunctionInference() {
    }
}

