/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class SourceQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_SOURCE";
    private final ContextResolvedTable contextResolvedTable;

    public SourceQueryOperation(ContextResolvedTable contextResolvedTable) {
        this.contextResolvedTable = contextResolvedTable;
    }

    public ContextResolvedTable getContextResolvedTable() {
        return this.contextResolvedTable;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.contextResolvedTable.getResolvedSchema();
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("identifier", this.getContextResolvedTable().getIdentifier().asSummaryString());
        args.put("fields", this.getResolvedSchema().getColumnNames());
        return OperationUtils.formatWithChildren("CatalogTable", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("SELECT %s FROM %s %s", OperationUtils.formatSelectColumns(this.getResolvedSchema(), INPUT_ALIAS), this.getContextResolvedTable().getIdentifier().asSerializableString(), INPUT_ALIAS);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

