/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTable;

public class SqlAlterMaterializedTableOptions
extends SqlAlterMaterializedTable {
    private final SqlNodeList propertyList;

    public SqlAlterMaterializedTableOptions(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyList) {
        super(pos, tableName);
        this.propertyList = propertyList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.getTableName(), this.propertyList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.propertyList) {
            SqlUnparseUtils.printIndent(writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

