/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.dataview.NullSerializer;
import org.apache.flink.table.legacy.types.logical.TypeInformationRawType;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

@Internal
final class LogicalTypeJsonSerializer
extends StdSerializer<LogicalType> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_TYPE_NAME = "type";
    static final String FIELD_NAME_NULLABLE = "nullable";
    static final String FIELD_NAME_DESCRIPTION = "description";
    static final String FIELD_NAME_LENGTH = "length";
    static final String FIELD_NAME_PRECISION = "precision";
    static final String FIELD_NAME_TIMESTAMP_KIND = "kind";
    static final String FIELD_NAME_ELEMENT_TYPE = "elementType";
    static final String FIELD_NAME_KEY_TYPE = "keyType";
    static final String FIELD_NAME_VALUE_TYPE = "valueType";
    static final String FIELD_NAME_FIELDS = "fields";
    static final String FIELD_NAME_FIELD_NAME = "name";
    static final String FIELD_NAME_FIELD_TYPE = "fieldType";
    static final String FIELD_NAME_FIELD_DESCRIPTION = "description";
    static final String FIELD_NAME_SOURCE_TYPE = "sourceType";
    static final String FIELD_NAME_OBJECT_IDENTIFIER = "objectIdentifier";
    static final String FIELD_NAME_IMPLEMENTATION_CLASS = "implementationClass";
    static final String FIELD_NAME_ATTRIBUTES = "attributes";
    static final String FIELD_NAME_ATTRIBUTE_NAME = "name";
    static final String FIELD_NAME_ATTRIBUTE_TYPE = "attributeType";
    static final String FIELD_NAME_ATTRIBUTE_DESCRIPTION = "description";
    static final String FIELD_NAME_FINAL = "final";
    static final String FIELD_NAME_INSTANTIABLE = "instantiable";
    static final String FIELD_NAME_COMPARISON = "comparison";
    static final String FIELD_NAME_SUPER_TYPE = "superType";
    static final String FIELD_NAME_CLASS = "class";
    static final String FIELD_NAME_EXTERNAL_DATA_TYPE = "externalDataType";
    static final String FIELD_NAME_SPECIAL_SERIALIZER = "specialSerializer";
    static final String FIELD_VALUE_EXTERNAL_SERIALIZER_NULL = "NULL";

    LogicalTypeJsonSerializer() {
        super(LogicalType.class);
    }

    public void serialize(LogicalType logicalType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ReadableConfig config = SerdeContext.get((DatabindContext)serializerProvider).getConfiguration();
        boolean serializeCatalogObjects = !((TableConfigOptions.CatalogPlanCompilation)config.get(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS)).equals((Object)TableConfigOptions.CatalogPlanCompilation.IDENTIFIER);
        LogicalTypeJsonSerializer.serializeInternal(logicalType, jsonGenerator, serializerProvider, serializeCatalogObjects);
    }

    private static void serializeInternal(LogicalType logicalType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        if (LogicalTypeJsonSerializer.supportsCompactSerialization(logicalType, serializeCatalogObjects)) {
            LogicalTypeJsonSerializer.serializeTypeWithCompactSerialization(logicalType, jsonGenerator);
        } else {
            LogicalTypeJsonSerializer.serializeTypeWithGenericSerialization(logicalType, jsonGenerator, serializerProvider, serializeCatalogObjects);
        }
    }

    private static void serializeTypeWithGenericSerialization(LogicalType logicalType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(FIELD_NAME_TYPE_NAME, logicalType.getTypeRoot().name());
        if (!logicalType.isNullable()) {
            jsonGenerator.writeBooleanField(FIELD_NAME_NULLABLE, false);
        }
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                LogicalTypeJsonSerializer.serializeZeroLengthString(jsonGenerator);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)logicalType;
                LogicalTypeJsonSerializer.serializeTimestamp(timestampType.getPrecision(), timestampType.getKind(), jsonGenerator, serializerProvider);
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                ZonedTimestampType zonedTimestampType = (ZonedTimestampType)logicalType;
                LogicalTypeJsonSerializer.serializeTimestamp(zonedTimestampType.getPrecision(), zonedTimestampType.getKind(), jsonGenerator, serializerProvider);
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType;
                LogicalTypeJsonSerializer.serializeTimestamp(localZonedTimestampType.getPrecision(), localZonedTimestampType.getKind(), jsonGenerator, serializerProvider);
                break;
            }
            case ARRAY: {
                LogicalTypeJsonSerializer.serializeCollection(((ArrayType)logicalType).getElementType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
                break;
            }
            case MULTISET: {
                LogicalTypeJsonSerializer.serializeCollection(((MultisetType)logicalType).getElementType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
                break;
            }
            case MAP: {
                LogicalTypeJsonSerializer.serializeMap((MapType)logicalType, jsonGenerator, serializerProvider, serializeCatalogObjects);
                break;
            }
            case ROW: {
                LogicalTypeJsonSerializer.serializeRow((RowType)logicalType, jsonGenerator, serializerProvider, serializeCatalogObjects);
                break;
            }
            case DISTINCT_TYPE: {
                LogicalTypeJsonSerializer.serializeDistinctType((DistinctType)logicalType, jsonGenerator, serializerProvider, serializeCatalogObjects);
                break;
            }
            case STRUCTURED_TYPE: {
                LogicalTypeJsonSerializer.serializeStructuredType((StructuredType)logicalType, jsonGenerator, serializerProvider, serializeCatalogObjects);
                break;
            }
            case SYMBOL: {
                break;
            }
            case RAW: {
                if (logicalType instanceof RawType) {
                    LogicalTypeJsonSerializer.serializeSpecializedRaw((RawType)logicalType, jsonGenerator, serializerProvider);
                    break;
                }
            }
            default: {
                throw new ValidationException(String.format("Unable to serialize logical type '%s'. Please check the documentation for supported types.", logicalType.asSummaryString()));
            }
        }
        jsonGenerator.writeEndObject();
    }

    private static void serializeZeroLengthString(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeNumberField(FIELD_NAME_LENGTH, 0);
    }

    private static void serializeTimestamp(int precision, TimestampKind kind, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumberField(FIELD_NAME_PRECISION, precision);
        serializerProvider.defaultSerializeField(FIELD_NAME_TIMESTAMP_KIND, (Object)kind, jsonGenerator);
    }

    private static void serializeCollection(LogicalType elementType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        jsonGenerator.writeFieldName(FIELD_NAME_ELEMENT_TYPE);
        LogicalTypeJsonSerializer.serializeInternal(elementType, jsonGenerator, serializerProvider, serializeCatalogObjects);
    }

    private static void serializeMap(MapType mapType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        jsonGenerator.writeFieldName(FIELD_NAME_KEY_TYPE);
        LogicalTypeJsonSerializer.serializeInternal(mapType.getKeyType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
        jsonGenerator.writeFieldName(FIELD_NAME_VALUE_TYPE);
        LogicalTypeJsonSerializer.serializeInternal(mapType.getValueType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
    }

    private static void serializeRow(RowType rowType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        jsonGenerator.writeArrayFieldStart(FIELD_NAME_FIELDS);
        for (RowType.RowField rowField : rowType.getFields()) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", rowField.getName());
            jsonGenerator.writeFieldName(FIELD_NAME_FIELD_TYPE);
            LogicalTypeJsonSerializer.serializeInternal(rowField.getType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
            if (rowField.getDescription().isPresent()) {
                jsonGenerator.writeStringField("description", (String)rowField.getDescription().get());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    private static void serializeDistinctType(DistinctType distinctType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        serializerProvider.defaultSerializeField(FIELD_NAME_OBJECT_IDENTIFIER, distinctType.getObjectIdentifier().orElseThrow(IllegalStateException::new), jsonGenerator);
        if (distinctType.getDescription().isPresent()) {
            jsonGenerator.writeStringField("description", (String)distinctType.getDescription().get());
        }
        jsonGenerator.writeFieldName(FIELD_NAME_SOURCE_TYPE);
        LogicalTypeJsonSerializer.serializeInternal(distinctType.getSourceType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
    }

    private static void serializeStructuredType(StructuredType structuredType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        if (structuredType.getObjectIdentifier().isPresent()) {
            serializerProvider.defaultSerializeField(FIELD_NAME_OBJECT_IDENTIFIER, structuredType.getObjectIdentifier().get(), jsonGenerator);
        }
        if (structuredType.getDescription().isPresent()) {
            jsonGenerator.writeStringField("description", (String)structuredType.getDescription().get());
        }
        if (structuredType.getImplementationClass().isPresent()) {
            serializerProvider.defaultSerializeField(FIELD_NAME_IMPLEMENTATION_CLASS, structuredType.getImplementationClass().get(), jsonGenerator);
        }
        jsonGenerator.writeFieldName(FIELD_NAME_ATTRIBUTES);
        jsonGenerator.writeStartArray();
        for (StructuredType.StructuredAttribute attribute : structuredType.getAttributes()) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", attribute.getName());
            jsonGenerator.writeFieldName(FIELD_NAME_ATTRIBUTE_TYPE);
            LogicalTypeJsonSerializer.serializeInternal(attribute.getType(), jsonGenerator, serializerProvider, serializeCatalogObjects);
            if (attribute.getDescription().isPresent()) {
                jsonGenerator.writeStringField("description", (String)attribute.getDescription().get());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        if (!structuredType.isFinal()) {
            jsonGenerator.writeBooleanField(FIELD_NAME_FINAL, false);
        }
        if (!structuredType.isInstantiable()) {
            jsonGenerator.writeBooleanField(FIELD_NAME_INSTANTIABLE, false);
        }
        if (structuredType.getComparison() != StructuredType.StructuredComparison.NONE) {
            jsonGenerator.writeStringField(FIELD_NAME_COMPARISON, structuredType.getComparison().name());
        }
        if (structuredType.getSuperType().isPresent()) {
            serializerProvider.defaultSerializeField(FIELD_NAME_SUPER_TYPE, structuredType.getSuperType().get(), jsonGenerator);
        }
    }

    private static void serializeSpecializedRaw(RawType<?> rawType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStringField(FIELD_NAME_CLASS, rawType.getOriginatingClass().getName());
        TypeSerializer serializer = rawType.getTypeSerializer();
        if (serializer.equals((Object)NullSerializer.INSTANCE)) {
            jsonGenerator.writeStringField(FIELD_NAME_SPECIAL_SERIALIZER, FIELD_VALUE_EXTERNAL_SERIALIZER_NULL);
        } else if (serializer instanceof ExternalSerializer) {
            ExternalSerializer externalSerializer = (ExternalSerializer)rawType.getTypeSerializer();
            if (externalSerializer.isInternalInput()) {
                throw new TableException("Asymmetric external serializers are currently not supported. The input must not be internal if the output is external.");
            }
            serializerProvider.defaultSerializeField(FIELD_NAME_EXTERNAL_DATA_TYPE, (Object)externalSerializer.getDataType(), jsonGenerator);
        } else {
            throw new TableException("Unsupported special case for RAW type.");
        }
    }

    private static boolean supportsCompactSerialization(LogicalType logicalType, boolean serializeCatalogObjects) {
        return (Boolean)logicalType.accept((LogicalTypeVisitor)new CompactSerializationChecker(serializeCatalogObjects));
    }

    private static void serializeTypeWithCompactSerialization(LogicalType logicalType, JsonGenerator jsonGenerator) throws IOException {
        String compactString = logicalType.asSerializableString();
        jsonGenerator.writeString(compactString);
    }

    private static class CompactSerializationChecker
    extends LogicalTypeDefaultVisitor<Boolean> {
        private final boolean serializeCatalogObjects;

        CompactSerializationChecker(boolean serializeCatalogObjects) {
            this.serializeCatalogObjects = serializeCatalogObjects;
        }

        public Boolean visit(CharType charType) {
            return charType.getLength() > 0;
        }

        public Boolean visit(VarCharType varCharType) {
            return varCharType.getLength() > 0;
        }

        public Boolean visit(BinaryType binaryType) {
            return binaryType.getLength() > 0;
        }

        public Boolean visit(VarBinaryType varBinaryType) {
            return varBinaryType.getLength() > 0;
        }

        public Boolean visit(TimestampType timestampType) {
            return timestampType.getKind() == TimestampKind.REGULAR;
        }

        public Boolean visit(ZonedTimestampType zonedTimestampType) {
            return zonedTimestampType.getKind() == TimestampKind.REGULAR;
        }

        public Boolean visit(LocalZonedTimestampType localZonedTimestampType) {
            return localZonedTimestampType.getKind() == TimestampKind.REGULAR;
        }

        public Boolean visit(DistinctType distinctType) {
            return !this.serializeCatalogObjects;
        }

        public Boolean visit(StructuredType structuredType) {
            return structuredType.getObjectIdentifier().isPresent() && !this.serializeCatalogObjects;
        }

        protected Boolean defaultMethod(LogicalType logicalType) {
            if (!logicalType.getChildren().stream().allMatch(t -> (Boolean)t.accept((LogicalTypeVisitor)this))) {
                return false;
            }
            switch (logicalType.getTypeRoot()) {
                case RAW: {
                    if (logicalType instanceof TypeInformationRawType) {
                        return false;
                    }
                    RawType rawType = (RawType)logicalType;
                    TypeSerializer serializer = rawType.getTypeSerializer();
                    if (serializer instanceof ExternalSerializer) {
                        return false;
                    }
                    if (serializer.equals((Object)NullSerializer.INSTANCE)) {
                        return false;
                    }
                }
                case ARRAY: 
                case MULTISET: 
                case MAP: 
                case ROW: 
                case BOOLEAN: 
                case DECIMAL: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: 
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_DAY_TIME: 
                case NULL: {
                    return true;
                }
            }
            return false;
        }
    }
}

