/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;

@Internal
final class RequiredDistributionJsonSerializer
extends StdSerializer<InputProperty.RequiredDistribution> {
    private static final long serialVersionUID = 1L;

    RequiredDistributionJsonSerializer() {
        super(InputProperty.RequiredDistribution.class);
    }

    public void serialize(InputProperty.RequiredDistribution requiredDistribution, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        InputProperty.DistributionType type = requiredDistribution.getType();
        jsonGenerator.writeStringField("type", type.name());
        switch (type) {
            case ANY: 
            case SINGLETON: 
            case BROADCAST: 
            case UNKNOWN: {
                break;
            }
            case KEEP_INPUT_AS_IS: {
                InputProperty.KeepInputAsIsDistribution asisDistribution = (InputProperty.KeepInputAsIsDistribution)requiredDistribution;
                jsonGenerator.writeFieldName("inputDistribution");
                this.serialize(asisDistribution.getInputDistribution(), jsonGenerator, serializerProvider);
                jsonGenerator.writeFieldName("isStrict");
                jsonGenerator.writeBoolean(asisDistribution.isStrict());
                break;
            }
            case HASH: {
                InputProperty.HashDistribution hashDistribution = (InputProperty.HashDistribution)requiredDistribution;
                jsonGenerator.writeFieldName("keys");
                jsonGenerator.writeArray(hashDistribution.getKeys(), 0, hashDistribution.getKeys().length);
                break;
            }
            default: {
                throw new TableException("Unsupported distribution type: " + type);
            }
        }
        jsonGenerator.writeEndObject();
    }
}

