/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.writer;

import com.aliyun.oss.model.PartETag;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.RefCountedFSOutputStream;
import org.apache.flink.fs.osshadoop.OSSAccessor;
import org.apache.flink.fs.osshadoop.writer.OSSCommitter;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSRecoverableMultipartUpload {
    private static final Logger LOG = LoggerFactory.getLogger(OSSRecoverableMultipartUpload.class);
    private String objectName;
    private String uploadId;
    private List<PartETag> completeParts;
    private Optional<File> incompletePart;
    private Executor uploadThreadPool;
    private OSSAccessor ossAccessor;
    private Deque<CompletableFuture<PartETag>> uploadsInProgress;
    private int numberOfRegisteredParts;
    private long expectedSizeInBytes;
    private final String namePrefixForTempObjects;

    public OSSRecoverableMultipartUpload(String objectName, Executor uploadThreadPool, OSSAccessor ossAccessor, Optional<File> incompletePart, String uploadId, List<PartETag> completeParts, long expectedSizeInBytes) {
        this.objectName = objectName;
        this.completeParts = completeParts != null ? completeParts : new ArrayList<PartETag>();
        this.incompletePart = incompletePart;
        this.uploadId = uploadId != null ? uploadId : ossAccessor.startMultipartUpload(objectName);
        this.uploadThreadPool = uploadThreadPool;
        this.ossAccessor = ossAccessor;
        this.uploadsInProgress = new ArrayDeque<CompletableFuture<PartETag>>();
        this.numberOfRegisteredParts = this.completeParts.size();
        this.expectedSizeInBytes = expectedSizeInBytes;
        this.namePrefixForTempObjects = OSSRecoverableMultipartUpload.createIncompletePartObjectNamePrefix(objectName);
    }

    public Optional<File> getIncompletePart() {
        return this.incompletePart;
    }

    public void uploadPart(RefCountedFSOutputStream file) throws IOException {
        Preconditions.checkState((boolean)file.isClosed());
        CompletableFuture<PartETag> future = new CompletableFuture<PartETag>();
        this.uploadsInProgress.add(future);
        ++this.numberOfRegisteredParts;
        this.expectedSizeInBytes += file.getPos();
        file.retain();
        this.uploadThreadPool.execute(new UploadTask(this.ossAccessor, this.objectName, this.uploadId, this.numberOfRegisteredParts, file, future));
    }

    public OSSRecoverable getRecoverable(RefCountedFSOutputStream file) throws IOException {
        String incompletePartObjectName = this.uploadSmallPart(file);
        Preconditions.checkState((this.numberOfRegisteredParts - this.completeParts.size() == this.uploadsInProgress.size() ? 1 : 0) != 0);
        while (this.numberOfRegisteredParts - this.completeParts.size() > 0) {
            PartETag nextPart;
            CompletableFuture<PartETag> next = this.uploadsInProgress.peekFirst();
            try {
                nextPart = next.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for part uploads to complete");
            }
            catch (ExecutionException e) {
                throw new IOException("Uploading parts failed ", e.getCause());
            }
            this.completeParts.add(nextPart);
            this.uploadsInProgress.removeFirst();
        }
        if (file == null) {
            return new OSSRecoverable(this.uploadId, this.objectName, this.completeParts, null, this.expectedSizeInBytes, 0L);
        }
        return new OSSRecoverable(this.uploadId, this.objectName, this.completeParts, incompletePartObjectName, this.expectedSizeInBytes, file.getPos());
    }

    private String uploadSmallPart(@Nullable RefCountedFSOutputStream file) throws IOException {
        if (file == null || file.getPos() == 0L) {
            return null;
        }
        String incompletePartObjectName = this.createIncompletePartObjectName();
        file.retain();
        try {
            this.ossAccessor.putObject(incompletePartObjectName, file.getInputFile());
        }
        finally {
            file.release();
        }
        return incompletePartObjectName;
    }

    private String createIncompletePartObjectName() {
        return this.namePrefixForTempObjects + UUID.randomUUID().toString();
    }

    @VisibleForTesting
    static String createIncompletePartObjectNamePrefix(String objectName) {
        String child;
        String parent;
        Preconditions.checkNotNull((Object)objectName);
        int lastSlash = objectName.lastIndexOf(47);
        if (lastSlash == -1) {
            parent = "";
            child = objectName;
        } else {
            parent = objectName.substring(0, lastSlash + 1);
            child = objectName.substring(lastSlash + 1);
        }
        return parent + (Serializable)(child.isEmpty() ? "" : Character.valueOf('_')) + child + "_tmp_";
    }

    public OSSCommitter getCommitter() throws IOException {
        OSSRecoverable recoverable = this.getRecoverable(null);
        return new OSSCommitter(this.ossAccessor, recoverable.getObjectName(), recoverable.getUploadId(), recoverable.getPartETags(), recoverable.getNumBytesInParts());
    }

    private static class UploadTask
    implements Runnable {
        private final OSSAccessor ossAccessor;
        private final String objectName;
        private final String uploadId;
        private final int partNumber;
        private final RefCountedFSOutputStream file;
        private final CompletableFuture<PartETag> future;

        UploadTask(OSSAccessor ossAccessor, String objectName, String uploadId, int partNumber, RefCountedFSOutputStream file, CompletableFuture<PartETag> future) {
            this.ossAccessor = ossAccessor;
            this.objectName = objectName;
            this.uploadId = uploadId;
            Preconditions.checkArgument((partNumber >= 1 && partNumber <= 10000 ? 1 : 0) != 0);
            this.partNumber = partNumber;
            this.file = file;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                PartETag partETag = this.ossAccessor.uploadPart(this.file.getInputFile(), this.objectName, this.uploadId, this.partNumber);
                this.future.complete(partETag);
                this.file.release();
            }
            catch (Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }
}

