/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.SqlConstraintValidator;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.ddl.position.SqlTableColumnPosition;
import org.apache.flink.sql.parser.error.SqlValidateException;

public abstract class SqlAlterTableSchema
extends SqlAlterTable
implements ExtendedSqlNode {
    protected final SqlNodeList columnList;
    @Nullable
    protected final SqlWatermark watermark;
    @Nullable
    protected final SqlDistribution distribution;
    protected final List<SqlTableConstraint> constraints;

    public SqlAlterTableSchema(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> constraints, @Nullable SqlWatermark sqlWatermark, @Nullable SqlDistribution distribution, boolean ifTableExists) {
        super(pos, tableName, ifTableExists);
        this.columnList = columnList;
        this.constraints = constraints;
        this.distribution = distribution;
        this.watermark = sqlWatermark;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.getTableName(), this.columnList, new SqlNodeList(this.constraints, SqlParserPos.ZERO), this.watermark);
    }

    @Override
    public void validate() throws SqlValidateException {
        SqlConstraintValidator.validateAndChangeColumnNullability(this.constraints, this.getColumns());
    }

    public SqlNodeList getColumnPositions() {
        return this.columnList;
    }

    public Optional<SqlWatermark> getWatermark() {
        return Optional.ofNullable(this.watermark);
    }

    public Optional<SqlDistribution> getDistribution() {
        return Optional.ofNullable(this.distribution);
    }

    public List<SqlTableConstraint> getConstraints() {
        return this.constraints;
    }

    public Optional<SqlTableConstraint> getFullConstraint() {
        List<SqlTableConstraint> primaryKeys = SqlConstraintValidator.getFullConstraints(this.constraints, this.getColumns());
        return primaryKeys.isEmpty() ? Optional.empty() : Optional.of(primaryKeys.get(0));
    }

    private SqlNodeList getColumns() {
        return new SqlNodeList(this.columnList.getList().stream().map(columnPos -> ((SqlTableColumnPosition)columnPos).getColumn()).collect(Collectors.toList()), SqlParserPos.ZERO);
    }

    void unparseSchemaAndDistribution(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.columnList != null && this.columnList.size() > 0 || this.constraints != null && this.constraints.size() > 0 || this.watermark != null) {
            SqlUnparseUtils.unparseTableSchema(writer, leftPrec, rightPrec, this.columnList, this.constraints, this.watermark);
        }
        if (this.distribution != null) {
            this.distribution.unparseAlter(writer, leftPrec, rightPrec);
        }
    }
}

