/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterables;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableWindowPropertiesHavingRuleConfig;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableWindowPropertiesRuleConfig;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.groupwindow.ProctimeAttribute;
import org.apache.flink.table.runtime.groupwindow.RowtimeAttribute;
import org.apache.flink.table.runtime.groupwindow.WindowEnd;
import org.apache.flink.table.runtime.groupwindow.WindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowStart;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.immutables.value.Value;

public class WindowPropertiesRules {
    public static final WindowPropertiesHavingRule WINDOW_PROPERTIES_HAVING_RULE = WindowPropertiesHavingRule.WindowPropertiesHavingRuleConfig.DEFAULT.toRule();
    public static final WindowPropertiesRule WINDOW_PROPERTIES_RULE = WindowPropertiesRule.WindowPropertiesRuleConfig.DEFAULT.toRule();

    public static RelNode convertWindowNodes(RelBuilder builder, LogicalProject project, Optional<LogicalFilter> filter, LogicalProject innerProject, LogicalWindowAggregate agg) {
        LogicalWindow w = agg.getWindow();
        WindowType windowType = WindowPropertiesRules.getWindowType(w);
        NamedWindowProperty startProperty = new NamedWindowProperty(WindowPropertiesRules.propertyName(w, "start"), (WindowProperty)new WindowStart(w.aliasAttribute()));
        NamedWindowProperty endProperty = new NamedWindowProperty(WindowPropertiesRules.propertyName(w, "end"), (WindowProperty)new WindowEnd(w.aliasAttribute()));
        List<NamedWindowProperty> startEndProperties = List.of(startProperty, endProperty);
        List<Object> timeProperties = new ArrayList();
        switch (windowType) {
            case STREAM_ROWTIME: {
                timeProperties = List.of(new NamedWindowProperty(WindowPropertiesRules.propertyName(w, "rowtime"), (WindowProperty)new RowtimeAttribute(w.aliasAttribute())), new NamedWindowProperty(WindowPropertiesRules.propertyName(w, "proctime"), (WindowProperty)new ProctimeAttribute(w.aliasAttribute())));
                break;
            }
            case STREAM_PROCTIME: {
                timeProperties = List.of(new NamedWindowProperty(WindowPropertiesRules.propertyName(w, "proctime"), (WindowProperty)new ProctimeAttribute(w.aliasAttribute())));
                break;
            }
            case BATCH_ROWTIME: {
                timeProperties = List.of(new NamedWindowProperty(WindowPropertiesRules.propertyName(w, "rowtime"), (WindowProperty)new RowtimeAttribute(w.aliasAttribute())));
                break;
            }
            default: {
                throw new TableException("Unknown window type encountered. Please report this bug.");
            }
        }
        ArrayList properties = Lists.newArrayList((Iterable)Iterables.concat(startEndProperties, timeProperties));
        builder.push(agg.copy(properties));
        List projectNodes = Stream.concat(innerProject.getProjects().stream(), properties.stream().map(np -> builder.field(np.getName()))).collect(Collectors.toList());
        builder.project(projectNodes);
        filter.ifPresent(f -> builder.filter(WindowPropertiesRules.replaceGroupAuxiliaries(f.getCondition(), w, builder)));
        List finalProjects = project.getProjects().stream().map(expr -> WindowPropertiesRules.replaceGroupAuxiliaries(expr, w, builder)).collect(Collectors.toList());
        builder.project(finalProjects, project.getRowType().getFieldNames());
        return builder.build();
    }

    private static WindowType getWindowType(LogicalWindow window) {
        if (AggregateUtil.isRowtimeAttribute(window.timeAttribute())) {
            return WindowType.STREAM_ROWTIME;
        }
        if (AggregateUtil.isProctimeAttribute(window.timeAttribute())) {
            return WindowType.STREAM_PROCTIME;
        }
        if (window.timeAttribute().getOutputDataType().getLogicalType().is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return WindowType.BATCH_ROWTIME;
        }
        throw new TableException("Unknown window type encountered. Please report this bug.");
    }

    private static String propertyName(LogicalWindow window, String name) {
        return window.aliasAttribute().getName() + name;
    }

    public static RexNode replaceGroupAuxiliaries(RexNode node, LogicalWindow window, RelBuilder builder) {
        RexBuilder rexBuilder = builder.getRexBuilder();
        WindowType windowType = WindowPropertiesRules.getWindowType(window);
        if (node instanceof RexCall) {
            RexCall c = (RexCall)node;
            if (WindowPropertiesRules.isWindowStart(c)) {
                return rexBuilder.makeCast(c.getType(), builder.field(WindowPropertiesRules.propertyName(window, "start")), false);
            }
            if (WindowPropertiesRules.isWindowEnd(c)) {
                return rexBuilder.makeCast(c.getType(), builder.field(WindowPropertiesRules.propertyName(window, "end")), false);
            }
            if (WindowPropertiesRules.isWindowRowtime(c)) {
                switch (windowType) {
                    case STREAM_ROWTIME: 
                    case BATCH_ROWTIME: {
                        return rexBuilder.makeCast(c.getType(), builder.field(WindowPropertiesRules.propertyName(window, "rowtime")), false);
                    }
                    case STREAM_PROCTIME: {
                        throw new ValidationException("A proctime window cannot provide a rowtime attribute.");
                    }
                }
                throw new TableException("Unknown window type encountered. Please report this bug.");
            }
            if (WindowPropertiesRules.isWindowProctime(c)) {
                switch (windowType) {
                    case STREAM_ROWTIME: 
                    case STREAM_PROCTIME: {
                        return rexBuilder.makeCast(c.getType(), builder.field(WindowPropertiesRules.propertyName(window, "proctime")), false);
                    }
                    case BATCH_ROWTIME: {
                        throw new ValidationException("PROCTIME window property is not supported in batch queries.");
                    }
                }
                throw new TableException("Unknown window type encountered. Please report this bug.");
            }
            List<RexNode> newOps = c.getOperands().stream().map(op -> WindowPropertiesRules.replaceGroupAuxiliaries(op, window, builder)).collect(Collectors.toList());
            return c.clone(c.getType(), newOps);
        }
        return node;
    }

    private static boolean isWindowStart(RexNode node) {
        RexCall c;
        if (node instanceof RexCall && (c = (RexCall)node).getOperator().isGroupAuxiliary()) {
            return c.getOperator() == FlinkSqlOperatorTable.TUMBLE_START || c.getOperator() == FlinkSqlOperatorTable.HOP_START || c.getOperator() == FlinkSqlOperatorTable.SESSION_START;
        }
        return false;
    }

    private static boolean isWindowEnd(RexNode node) {
        RexCall c;
        if (node instanceof RexCall && (c = (RexCall)node).getOperator().isGroupAuxiliary()) {
            return c.getOperator() == FlinkSqlOperatorTable.TUMBLE_END || c.getOperator() == FlinkSqlOperatorTable.HOP_END || c.getOperator() == FlinkSqlOperatorTable.SESSION_END;
        }
        return false;
    }

    private static boolean isWindowRowtime(RexNode node) {
        RexCall c;
        if (node instanceof RexCall && (c = (RexCall)node).getOperator().isGroupAuxiliary()) {
            return c.getOperator() == FlinkSqlOperatorTable.TUMBLE_ROWTIME || c.getOperator() == FlinkSqlOperatorTable.HOP_ROWTIME || c.getOperator() == FlinkSqlOperatorTable.SESSION_ROWTIME;
        }
        return false;
    }

    private static boolean isWindowProctime(RexNode node) {
        RexCall c;
        if (node instanceof RexCall && (c = (RexCall)node).getOperator().isGroupAuxiliary()) {
            return c.getOperator() == FlinkSqlOperatorTable.TUMBLE_PROCTIME || c.getOperator() == FlinkSqlOperatorTable.HOP_PROCTIME || c.getOperator() == FlinkSqlOperatorTable.SESSION_PROCTIME;
        }
        return false;
    }

    public static boolean hasGroupAuxiliaries(RexNode node) {
        if (node instanceof RexCall) {
            RexCall c = (RexCall)node;
            if (c.getOperator().isGroupAuxiliary()) {
                return true;
            }
            return c.getOperands().stream().anyMatch(WindowPropertiesRules::hasGroupAuxiliaries);
        }
        return false;
    }

    public static boolean hasGroupFunction(RexNode node) {
        if (node instanceof RexCall) {
            RexCall c = (RexCall)node;
            if (c.getOperator().isGroup()) {
                return true;
            }
            return c.getOperands().stream().anyMatch(WindowPropertiesRules::hasGroupFunction);
        }
        return false;
    }

    static enum WindowType {
        STREAM_ROWTIME,
        STREAM_PROCTIME,
        BATCH_ROWTIME;

    }

    public static class WindowPropertiesHavingRule
    extends RelRule<WindowPropertiesHavingRuleConfig> {
        protected WindowPropertiesHavingRule(WindowPropertiesHavingRuleConfig config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            LogicalFilter filter = (LogicalFilter)call.rel(1);
            return project.getProjects().stream().anyMatch(WindowPropertiesRules::hasGroupAuxiliaries) || WindowPropertiesRules.hasGroupAuxiliaries(filter.getCondition());
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            LogicalFilter filter = (LogicalFilter)call.rel(1);
            LogicalProject innerProject = (LogicalProject)call.rel(2);
            LogicalWindowAggregate agg = (LogicalWindowAggregate)call.rel(3);
            RelNode converted = WindowPropertiesRules.convertWindowNodes(call.builder(), project, Optional.of(filter), innerProject, agg);
            call.transformTo(converted);
        }

        @Value.Immutable(singleton=false)
        public static interface WindowPropertiesHavingRuleConfig
        extends RelRule.Config {
            public static final WindowPropertiesHavingRuleConfig DEFAULT = ImmutableWindowPropertiesHavingRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(LogicalFilter.class).oneInput(b2 -> b2.operand(LogicalProject.class).oneInput(b3 -> b3.operand(LogicalWindowAggregate.class).noInputs())))).withDescription("WindowPropertiesHavingRule");

            @Override
            default public WindowPropertiesHavingRule toRule() {
                return new WindowPropertiesHavingRule(this);
            }
        }
    }

    public static class WindowPropertiesRule
    extends RelRule<WindowPropertiesRuleConfig> {
        protected WindowPropertiesRule(WindowPropertiesRuleConfig config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            return project.getProjects().stream().anyMatch(WindowPropertiesRules::hasGroupAuxiliaries);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            LogicalProject innerProject = (LogicalProject)call.rel(1);
            LogicalWindowAggregate agg = (LogicalWindowAggregate)call.rel(2);
            RelNode converted = WindowPropertiesRules.convertWindowNodes(call.builder(), project, Optional.empty(), innerProject, agg);
            call.transformTo(converted);
        }

        @Value.Immutable(singleton=false)
        public static interface WindowPropertiesRuleConfig
        extends RelRule.Config {
            public static final WindowPropertiesRuleConfig DEFAULT = ImmutableWindowPropertiesRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(LogicalProject.class).oneInput(b2 -> b2.operand(LogicalWindowAggregate.class).noInputs()))).withDescription("WindowPropertiesRule");

            @Override
            default public WindowPropertiesRule toRule() {
                return new WindowPropertiesRule(this);
            }
        }
    }
}

