/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.legacy.table.sources.StreamTableSource;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.legacy.api.TableColumn;
import org.apache.flink.table.legacy.api.WatermarkSpec;
import org.apache.flink.table.legacy.sources.TableSource;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.TableSchemaUtils;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0007\u000f\u0001uA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0001L\u0011!\u0011\u0006A!A!\u0002\u0013a\u0005\u0002C*\u0001\u0005\u000b\u0007I\u0011\u0001+\t\u0011i\u0003!\u0011!Q\u0001\nUCQa\u0017\u0001\u0005\u0002qC\u0001b\u001c\u0001\t\u0006\u0004%\t\u0001\u001d\u0005\u0006i\u0002!\t%\u001e\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\u0012\u0001\u0004T3hC\u000eL8)\u0019;bY><7k\\;sG\u0016$\u0016M\u00197f\u0015\ty\u0001#\u0001\u0004tG\",W.\u0019\u0006\u0003#I\tA\u0001\u001d7b]*\u00111\u0003F\u0001\ba2\fgN\\3s\u0015\t)b#A\u0003uC\ndWM\u0003\u0002\u00181\u0005)a\r\\5oW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001)\"A\b1\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u0005q\u0011B\u0001\u0012\u000f\u0005]1E.\u001b8l!J,\u0007/\u0019:j]\u001e$\u0016M\u00197f\u0005\u0006\u001cX-\u0001\u0007sK2|\u0005\u000f^*dQ\u0016l\u0017\r\u0005\u0002&S5\taE\u0003\u0002\u0012O)\u0011\u0001\u0006G\u0001\bG\u0006d7-\u001b;f\u0013\tQcE\u0001\u0007SK2|\u0005\u000f^*dQ\u0016l\u0017-A\u0003oC6,7\u000fE\u0002.eQj\u0011A\f\u0006\u0003_A\nA!\u001e;jY*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005\u0011a\u0015n\u001d;\u0011\u0005UrdB\u0001\u001c=!\t9$(D\u00019\u0015\tID$\u0001\u0004=e>|GO\u0010\u0006\u0002w\u0005)1oY1mC&\u0011QHO\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>u\u00059!o\\<UsB,\u0007CA\"I\u001b\u0005!%BA#G\u0003\u0011!\u0018\u0010]3\u000b\u0005\u001d;\u0013a\u0001:fY&\u0011\u0011\n\u0012\u0002\f%\u0016dG)\u0019;b)f\u0004X-A\u0006tG\",W.\u0019+bE2,W#\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0005=\u0013\u0012aB2bi\u0006dwnZ\u0005\u0003#:\u0013!cQ1uC2|wmU2iK6\fG+\u00192mK\u0006a1o\u00195f[\u0006$\u0016M\u00197fA\u0005a1-\u0019;bY><G+\u00192mKV\tQ\u000b\u0005\u0002W16\tqK\u0003\u0002P)%\u0011\u0011l\u0016\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.Z\u0001\u000eG\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0011\u0002\rqJg.\u001b;?)\u0019i&n\u001b7n]B\u0019\u0001\u0005\u00010\u0011\u0005}\u0003G\u0002\u0001\u0003\u0006C\u0002\u0011\rA\u0019\u0002\u0002)F\u00111m\u001a\t\u0003I\u0016l\u0011AO\u0005\u0003Mj\u0012qAT8uQ&tw\r\u0005\u0002eQ&\u0011\u0011N\u000f\u0002\u0004\u0003:L\b\"B\u0012\t\u0001\u0004!\u0003\"B\u0016\t\u0001\u0004a\u0003\"B!\t\u0001\u0004\u0011\u0005\"\u0002&\t\u0001\u0004a\u0005\"B*\t\u0001\u0004)\u0016aC2pYVlg.\u0012=qeN,\u0012!\u001d\t\u0005kI$D'\u0003\u0002t\u0001\n\u0019Q*\u00199\u0002\u000bQ|'+\u001a7\u0015\u0005YT\bCA<y\u001b\u00051\u0015BA=G\u0005\u001d\u0011V\r\u001c(pI\u0016DQa\u001f\u0006A\u0002q\fqaY8oi\u0016DH\u000fE\u0002~\u0003\u0003q!!\n@\n\u0005}4\u0013a\u0003*fY>\u0003H\u000fV1cY\u0016LA!a\u0001\u0002\u0006\taAk\u001c*fY\u000e{g\u000e^3yi*\u0011qPJ\u0001\u001fM&tG-\u00118e\u0007J,\u0017\r^3MK\u001e\f7-\u001f+bE2,7k\\;sG\u0016$b!a\u0003\u0002\u001c\u0005\u0005\u0003#BA\u0007\u0003/qVBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u000fM|WO]2fg*\u0019\u0011Q\u0003\u000b\u0002\r1,w-Y2z\u0013\u0011\tI\"a\u0004\u0003\u0017Q\u000b'\r\\3T_V\u00148-\u001a\u0005\b\u0003;Y\u0001\u0019AA\u0010\u00035A\u0017N\u001c;fI>\u0003H/[8ogB1\u0011\u0011EA\u001eiQrA!a\t\u000289!\u0011QEA\u001b\u001d\u0011\t9#a\r\u000f\t\u0005%\u0012\u0011\u0007\b\u0005\u0003W\tyCD\u00028\u0003[I\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012BA\n\u0015\u0013\r\tIDE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\t)k\u0015\r\u001d\u0006\u0004\u0003s\u0011\u0002bBA\"\u0017\u0001\u0007\u0011QI\u0001\u0005G>tg\r\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYEF\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\u000f%\u0016\fG-\u00192mK\u000e{gNZ5h\u0003I)'/Y:f)&lW-\u00138eS\u000e\fGo\u001c:\u0015\u000f\t\u000b)&!\u0017\u0002h!1\u0011q\u000b\u0007A\u0002\t\u000b1B]3m\t\u0006$\u0018\rV=qK\"9\u00111\f\u0007A\u0002\u0005u\u0013a\u00024bGR|'/\u001f\t\u0005\u0003?\n\u0019'\u0004\u0002\u0002b)\u0011\u0001FE\u0005\u0005\u0003K\n\tG\u0001\tGY&t7\u000eV=qK\u001a\u000b7\r^8ss\"9\u0011\u0011\u000e\u0007A\u0002\u0005-\u0014a\u0003;bE2,7k\\;sG\u0016\u0004D!!\u001c\u0002rA1\u0011QBA\f\u0003_\u00022aXA9\t-\t\u0019(a\u001a\u0002\u0002\u0003\u0005)\u0011\u00012\u0003\u0007}#\u0013\u0007")
public class LegacyCatalogSourceTable<T>
extends FlinkPreparingTableBase {
    private scala.collection.immutable.Map<String, String> columnExprs;
    private final RelOptSchema relOptSchema;
    private final RelDataType rowType;
    private final CatalogSchemaTable schemaTable;
    private final CatalogTable catalogTable;
    private volatile boolean bitmap$0;

    public CatalogSchemaTable schemaTable() {
        return this.schemaTable;
    }

    public CatalogTable catalogTable() {
        return this.catalogTable;
    }

    private scala.collection.immutable.Map<String, String> columnExprs$lzycompute() {
        LegacyCatalogSourceTable legacyCatalogSourceTable = this;
        synchronized (legacyCatalogSourceTable) {
            if (!this.bitmap$0) {
                this.columnExprs = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.catalogTable().getSchema().getTableColumns()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    TableColumn tableColumn = x0$1;
                    if (tableColumn instanceof TableColumn.ComputedColumn) {
                        TableColumn.ComputedColumn computedColumn = (TableColumn.ComputedColumn)tableColumn;
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)computedColumn.getName(), (Object)computedColumn.getExpression())));
                    }
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = true;
            }
        }
        return this.columnExprs;
    }

    public scala.collection.immutable.Map<String, String> columnExprs() {
        if (!this.bitmap$0) {
            return this.columnExprs$lzycompute();
        }
        return this.columnExprs;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        Object object;
        Object object2;
        RelOptCluster cluster = context.getCluster();
        FlinkContext flinkContext = ShortcutUtils.unwrapContext(cluster);
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        TableConfig tableConfig = flinkContext.getTableConfig();
        Map<String, String> hintedOptions = FlinkHints.getHintedOptions(context.getTableHints());
        if (JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(hintedOptions).nonEmpty() && !Predef$.MODULE$.Boolean2boolean((Boolean)tableConfig.get(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED))) {
            throw new ValidationException(new StringBuilder(49).append("OPTIONS").append(" hint is allowed only when ").append(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()).append(" ").append("is set to true").toString());
        }
        TableSource<T> tableSource = this.findAndCreateLegacyTableSource(hintedOptions, (ReadableConfig)tableConfig);
        RelDataType actualRowType = this.eraseTimeIndicator(this.rowType, typeFactory, tableSource);
        LegacyTableSourceTable<T> tableSourceTable = new LegacyTableSourceTable<T>(this.relOptSchema, this.schemaTable().getContextResolvedTable().getIdentifier(), actualRowType, this.statistic, tableSource, this.schemaTable().isStreamingMode(), this.catalogTable(), hintedOptions);
        int[] physicalFields = (int[])((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldList()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LegacyCatalogSourceTable.$anonfun$toRel$1(this, f)))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)f.getIndex()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        LegacyTableSourceTable<T> newRelTable = tableSourceTable.copy(tableSource, physicalFields);
        LogicalTableScan scan = LogicalTableScan.create(cluster, newRelTable, context.getTableHints());
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(cluster, this.getRelOptSchema());
        relBuilder.push(scan);
        RexFactory rexFactory = flinkContext.getRexFactory();
        Buffer fieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(actualRowType.getFieldNames()).asScala();
        if (this.columnExprs().nonEmpty()) {
            String[] fieldExprs = (String[])((TraversableOnce)fieldNames.map((Function1 & Serializable & scala.Serializable)name -> {
                if (this.columnExprs().contains(name)) {
                    return (String)this.columnExprs().apply(name);
                }
                return new StringBuilder(2).append("`").append((String)name).append("`").toString();
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNode[] rexNodes = rexFactory.createSqlToRexConverter(newRelTable.getRowType(), null).convertToRexNodes(fieldExprs);
            object2 = relBuilder.projectNamed(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rexNodes)).toList()), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(fieldNames), true);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option watermarkSpec = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.catalogTable().getSchema().getWatermarkSpecs()).asScala()).headOption();
        if (this.schemaTable().isStreamingMode() && watermarkSpec.nonEmpty()) {
            if (TableSourceValidation.hasRowtimeAttribute(tableSource)) {
                throw new TableException("If watermark is specified in DDL, the underlying TableSource of connector shouldn't return an non-empty list of RowtimeAttributeDescriptor via DefinedRowtimeAttributes interface.");
            }
            String rowtime = ((WatermarkSpec)watermarkSpec.get()).getRowtimeAttribute();
            if (rowtime.contains(".")) {
                throw new TableException(new StringBuilder(64).append("Nested field '").append(rowtime).append("' as rowtime attribute is not supported right now.").toString());
            }
            int rowtimeIndex = fieldNames.indexOf((Object)rowtime);
            RexNode watermarkRexNode = rexFactory.createSqlToRexConverter(actualRowType, null).convertToRexNode(((WatermarkSpec)watermarkSpec.get()).getWatermarkExpr());
            object = relBuilder.watermark(rowtimeIndex, watermarkRexNode);
        } else {
            object = BoxedUnit.UNIT;
        }
        return relBuilder.build();
    }

    private TableSource<T> findAndCreateLegacyTableSource(Map<String, String> hintedOptions, ReadableConfig conf) {
        CatalogTable tableToFind = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(hintedOptions).nonEmpty() ? this.catalogTable().copy(FlinkHints.mergeTableOptions(hintedOptions, this.catalogTable().getOptions())) : this.catalogTable();
        ObjectIdentifier identifier = this.schemaTable().getContextResolvedTable().getIdentifier();
        ResolvedSchema resolvedSchemaWithRemovedTimeAttribute = TableSchemaUtils.removeTimeAttributeFromResolvedSchema((ResolvedSchema)this.schemaTable().getContextResolvedTable().getResolvedSchema());
        TableSource tableSource = TableFactoryUtil.findAndCreateTableSource((ObjectIdentifier)identifier, (CatalogTable)new ResolvedCatalogTable(CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchemaWithRemovedTimeAttribute).build()).comment(tableToFind.getComment()).partitionKeys(tableToFind.getPartitionKeys()).options(tableToFind.getOptions()).build(), resolvedSchemaWithRemovedTimeAttribute), (ReadableConfig)conf, (boolean)this.schemaTable().isTemporary());
        String tableName = identifier.asSummaryString();
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof StreamTableSource) {
            StreamTableSource streamTableSource = (StreamTableSource)tableSource2;
            if (!this.schemaTable().isStreamingMode() && !streamTableSource.isBounded()) {
                throw new ValidationException(new StringBuilder(71).append("Cannot query on an unbounded source in batch mode, ").append("but '").append(tableName).append("' is unbounded.").toString());
            }
        } else {
            throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource");
        }
        return tableSource;
    }

    private RelDataType eraseTimeIndicator(RelDataType relDataType, FlinkTypeFactory factory, TableSource<?> tableSource) {
        boolean hasLegacyTimeAttributes;
        boolean bl = hasLegacyTimeAttributes = TableSourceValidation.hasRowtimeAttribute(tableSource) || TableSourceValidation.hasProctimeAttribute(tableSource);
        if (this.columnExprs().isEmpty() && this.catalogTable().getSchema().getWatermarkSpecs().isEmpty() && hasLegacyTimeAttributes) {
            return relDataType;
        }
        RowType logicalRowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(relDataType);
        List fieldNames = logicalRowType.getFieldNames();
        Buffer fieldTypes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicalRowType.getFields()).map((Function1 & Serializable & scala.Serializable)f -> {
            if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(f.getType())) {
                LogicalType logicalType = f.getType();
                if (logicalType instanceof TimestampType) {
                    TimestampType timestampType = (TimestampType)logicalType;
                    return new TimestampType(timestampType.isNullable(), TimestampKind.REGULAR, timestampType.getPrecision());
                }
                if (logicalType instanceof LocalZonedTimestampType) {
                    LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType;
                    return new LocalZonedTimestampType(localZonedTimestampType.isNullable(), TimestampKind.REGULAR, localZonedTimestampType.getPrecision());
                }
                throw new ValidationException(new StringBuilder(75).append("The supported time indicator type are TIMESTAMP and TIMESTAMP_LTZ, but is ").append(f.getType()).append(".").toString());
            }
            return f.getType();
        }, Buffer$.MODULE$.canBuildFrom());
        return factory.buildRelNodeRowType((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(fieldNames).asScala()), (Seq<LogicalType>)fieldTypes);
    }

    public static final /* synthetic */ boolean $anonfun$toRel$1(LegacyCatalogSourceTable $this, RelDataTypeField f) {
        return !$this.columnExprs().contains((Object)f.getName());
    }

    public LegacyCatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable, CatalogTable catalogTable) {
        this.relOptSchema = relOptSchema;
        this.rowType = rowType;
        this.schemaTable = schemaTable;
        this.catalogTable = catalogTable;
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
    }
}

