/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.generator;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.flink.streaming.examples.statemachine.dfa.EventTypeAndState;
import org.apache.flink.streaming.examples.statemachine.dfa.State;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.event.EventType;
import org.apache.flink.util.Preconditions;

public class EventsGenerator {
    private final Random rnd;
    private final LinkedHashMap<Integer, State> states;
    private final double errorProb;

    public EventsGenerator() {
        this(0.0);
    }

    public EventsGenerator(double errorProb) {
        Preconditions.checkArgument((errorProb >= 0.0 && errorProb <= 1.0 ? 1 : 0) != 0, (Object)"Invalid error probability");
        this.errorProb = errorProb;
        this.rnd = new Random();
        this.states = new LinkedHashMap();
    }

    public Event next(int minIp, int maxIp) {
        double p = this.rnd.nextDouble();
        if (p * 1000.0 >= (double)this.states.size()) {
            int nextIP = this.rnd.nextInt(maxIp - minIp) + minIp;
            if (!this.states.containsKey(nextIP)) {
                EventTypeAndState eventAndState = State.Initial.randomTransition(this.rnd);
                this.states.put(nextIP, eventAndState.state);
                return new Event(eventAndState.eventType, nextIP);
            }
            return this.next(minIp, maxIp);
        }
        int numToSkip = Math.min(20, this.rnd.nextInt(this.states.size()));
        Iterator<Map.Entry<Integer, State>> iter = this.states.entrySet().iterator();
        for (int i = numToSkip; i > 0; --i) {
            iter.next();
        }
        Map.Entry<Integer, State> entry = iter.next();
        State currentState = entry.getValue();
        int address = entry.getKey();
        iter.remove();
        if (p < this.errorProb) {
            EventType event = currentState.randomInvalidTransition(this.rnd);
            return new Event(event, address);
        }
        EventTypeAndState eventAndState = currentState.randomTransition(this.rnd);
        if (!eventAndState.state.isTerminal()) {
            this.states.put(address, eventAndState.state);
        }
        return new Event(eventAndState.eventType, address);
    }

    @Nullable
    public Event nextInvalid() {
        Iterator<Map.Entry<Integer, State>> iter = this.states.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<Integer, State> entry = iter.next();
            State currentState = entry.getValue();
            int address = entry.getKey();
            iter.remove();
            EventType event = currentState.randomInvalidTransition(this.rnd);
            return new Event(event, address);
        }
        return null;
    }

    public int numActiveEntries() {
        return this.states.size();
    }
}

