/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;

@Internal
public final class RootArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final LogicalTypeRoot expectedRoot;
    @Nullable
    private final Boolean expectedNullability;

    public RootArgumentTypeStrategy(LogicalTypeRoot expectedRoot, @Nullable Boolean expectedNullability) {
        this.expectedRoot = (LogicalTypeRoot)((Object)Preconditions.checkNotNull((Object)((Object)expectedRoot)));
        this.expectedNullability = expectedNullability;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType actualDataType = callContext.getArgumentDataTypes().get(argumentPos);
        LogicalType actualType = actualDataType.getLogicalType();
        if (Objects.equals(this.expectedNullability, Boolean.FALSE) && actualType.isNullable()) {
            return callContext.fail(throwOnFailure, "Unsupported argument type. Expected nullable type of root '%s' but actual type was '%s'.", new Object[]{this.expectedRoot, actualType});
        }
        return StrategyUtils.findDataType(callContext, throwOnFailure, actualDataType, this.expectedRoot, this.expectedNullability);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        if (Objects.equals(this.expectedNullability, Boolean.TRUE)) {
            return Signature.Argument.ofGroup(String.valueOf((Object)this.expectedRoot) + " NULL");
        }
        if (Objects.equals(this.expectedNullability, Boolean.FALSE)) {
            return Signature.Argument.ofGroup(String.valueOf((Object)this.expectedRoot) + " NOT NULL");
        }
        return Signature.Argument.ofGroup(this.expectedRoot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootArgumentTypeStrategy strategy = (RootArgumentTypeStrategy)o;
        return this.expectedRoot == strategy.expectedRoot && Objects.equals(this.expectedNullability, strategy.expectedNullability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expectedRoot, this.expectedNullability});
    }
}

