/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.storage.GSBlobStorage;
import org.apache.flink.fs.gs.utils.BlobUtils;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.fs.gs.writer.GSCommitRecoverableSerializer;
import org.apache.flink.fs.gs.writer.GSRecoverableFsDataOutputStream;
import org.apache.flink.fs.gs.writer.GSRecoverableWriterCommitter;
import org.apache.flink.fs.gs.writer.GSResumeRecoverable;
import org.apache.flink.fs.gs.writer.GSResumeRecoverableSerializer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSRecoverableWriter
implements RecoverableWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSRecoverableWriter.class);
    private final GSBlobStorage storage;
    private final GSFileSystemOptions options;

    public GSRecoverableWriter(GSBlobStorage storage, GSFileSystemOptions options) {
        LOGGER.debug("Creating GSRecoverableWriter with options {}", (Object)options);
        this.storage = (GSBlobStorage)Preconditions.checkNotNull((Object)storage);
        this.options = (GSFileSystemOptions)Preconditions.checkNotNull((Object)options);
    }

    public boolean requiresCleanupOfRecoverableState() {
        return false;
    }

    public boolean supportsResume() {
        return true;
    }

    public RecoverableFsDataOutputStream open(Path path) throws IOException {
        LOGGER.trace("Opening output stream for path {}", (Object)path);
        Preconditions.checkNotNull((Object)path);
        GSBlobIdentifier finalBlobIdentifier = BlobUtils.parseUri(path.toUri());
        return new GSRecoverableFsDataOutputStream(this.storage, this.options, finalBlobIdentifier);
    }

    public RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable resumable) {
        LOGGER.trace("Recovering output stream: {}", (Object)resumable);
        Preconditions.checkNotNull((Object)resumable);
        GSResumeRecoverable recoverable = (GSResumeRecoverable)resumable;
        return new GSRecoverableFsDataOutputStream(this.storage, this.options, recoverable);
    }

    public boolean cleanupRecoverableState(RecoverableWriter.ResumeRecoverable resumable) {
        return true;
    }

    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable resumable) {
        LOGGER.trace("Recovering output stream for commit: {}", (Object)resumable);
        Preconditions.checkNotNull((Object)resumable);
        GSCommitRecoverable recoverable = (GSCommitRecoverable)resumable;
        return new GSRecoverableWriterCommitter(this.storage, this.options, recoverable);
    }

    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        return GSCommitRecoverableSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        return GSResumeRecoverableSerializer.INSTANCE;
    }
}

