/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.TableVersionBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.ibatis.annotations.Param;

public class TableVersionPostgreSQLProvider
extends TableVersionBaseSQLProvider {
    @Override
    public String insertTableVersionOnDuplicateKeyUpdate(@Param(value="tablePO") TablePO tablePO) {
        return "INSERT INTO table_version_info (table_id, format, properties, partitioning, distribution, sort_orders, indexes, comment, version, deleted_at) VALUES ( #{tablePO.tableId}, #{tablePO.format}, #{tablePO.properties}, #{tablePO.partitions}, #{tablePO.distribution}, #{tablePO.sortOrders}, #{tablePO.indexes}, #{tablePO.comment}, #{tablePO.currentVersion}, #{tablePO.deletedAt} ) ON CONFLICT (table_id, version, deleted_at) DO UPDATE SET format = #{tablePO.format}, properties = #{tablePO.properties}, partitioning = #{tablePO.partitions}, distribution = #{tablePO.distribution}, sort_orders = #{tablePO.sortOrders}, indexes = #{tablePO.indexes}, comment = #{tablePO.comment}, version = #{tablePO.currentVersion}, deleted_at = #{tablePO.deletedAt}";
    }

    @Override
    public String softDeleteTableVersionByTableIdAndVersion(Long tableId, Long version) {
        return "UPDATE table_version_info SET deleted_at = round(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00')) * 1000) WHERE table_id = #{tableId} AND version = #{version}";
    }

    @Override
    public String deleteTableVersionByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM table_version_info WHERE table_id IN (SELECT table_id FROM table_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

