/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.TableMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.ibatis.annotations.Param;

public class TableMetaPostgreSQLProvider
extends TableMetaBaseSQLProvider {
    @Override
    public String insertTableMetaOnDuplicateKeyUpdate(TablePO tablePO) {
        return "INSERT INTO table_meta (table_id, table_name, metalake_id, catalog_id, schema_id, audit_info, current_version, last_version, deleted_at) VALUES ( #{tableMeta.tableId}, #{tableMeta.tableName}, #{tableMeta.metalakeId}, #{tableMeta.catalogId}, #{tableMeta.schemaId}, #{tableMeta.auditInfo}, #{tableMeta.currentVersion}, #{tableMeta.lastVersion}, #{tableMeta.deletedAt} ) ON CONFLICT (table_id) DO UPDATE SET table_name = #{tableMeta.tableName}, metalake_id = #{tableMeta.metalakeId}, catalog_id = #{tableMeta.catalogId}, schema_id = #{tableMeta.schemaId}, audit_info = #{tableMeta.auditInfo}, current_version = #{tableMeta.currentVersion}, last_version = #{tableMeta.lastVersion}, deleted_at = #{tableMeta.deletedAt}";
    }

    @Override
    public String softDeleteTableMetasByTableId(Long tableId) {
        return "UPDATE table_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE table_id = #{tableId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTableMetasByMetalakeId(Long metalakeId) {
        return "UPDATE table_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTableMetasByCatalogId(Long catalogId) {
        return "UPDATE table_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTableMetasBySchemaId(Long schemaId) {
        return "UPDATE table_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    @Override
    public String deleteTableMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM table_meta WHERE table_id IN (SELECT table_id FROM table_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

