/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QueueBalancer;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class BalancedQueueRpcExecutor
extends RpcExecutor {
    private final QueueBalancer balancer;

    public BalancedQueueRpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this(name, handlerCount, conf.get("hbase.ipc.server.callqueue.type", "fifo"), maxQueueLength, priority, conf, abortable);
    }

    public BalancedQueueRpcExecutor(String name, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, callQueueType, maxQueueLength, priority, conf, abortable);
        this.initializeQueues(this.numCallQueues);
        this.balancer = BalancedQueueRpcExecutor.getBalancer(name, conf, this.getQueues());
    }

    @Override
    public boolean dispatch(CallRunner callTask) {
        int queueIndex = this.balancer.getNextQueue(callTask);
        BlockingQueue queue = (BlockingQueue)this.queues.get(queueIndex);
        if (queue.size() >= this.currentQueueLimit) {
            return false;
        }
        return queue.offer(callTask);
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        super.onConfigurationChange(conf);
        if (this.balancer instanceof ConfigurationObserver) {
            ((ConfigurationObserver)this.balancer).onConfigurationChange(conf);
        }
    }
}

