/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionState {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionState.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testSerializeDeserialize() {
        TableName tableName = TableName.valueOf((String)"testtb");
        for (RegionState.State state : RegionState.State.values()) {
            this.testSerializeDeserialize(tableName, state);
        }
    }

    private void testSerializeDeserialize(TableName tableName, RegionState.State state) {
        RegionState state1 = RegionState.createForTesting((RegionInfo)new HRegionInfo(tableName), (RegionState.State)state);
        ClusterStatusProtos.RegionState protobuf1 = state1.convert();
        RegionState state2 = RegionState.convert((ClusterStatusProtos.RegionState)protobuf1);
        ClusterStatusProtos.RegionState protobuf2 = state1.convert();
        Assert.assertEquals((String)("RegionState does not match " + state), (Object)state1, (Object)state2);
        Assert.assertEquals((String)("Protobuf does not match " + state), (Object)protobuf1, (Object)protobuf2);
    }
}

