/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifier;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifierFactoryImpl;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotQuotaObserverChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotQuotaObserverChore.class);
    static final String SNAPSHOT_QUOTA_CHORE_PERIOD_KEY = "hbase.master.quotas.snapshot.chore.period";
    static final int SNAPSHOT_QUOTA_CHORE_PERIOD_DEFAULT = 300000;
    static final String SNAPSHOT_QUOTA_CHORE_DELAY_KEY = "hbase.master.quotas.snapshot.chore.delay";
    static final long SNAPSHOT_QUOTA_CHORE_DELAY_DEFAULT = 60000L;
    static final String SNAPSHOT_QUOTA_CHORE_TIMEUNIT_KEY = "hbase.master.quotas.snapshot.chore.timeunit";
    static final String SNAPSHOT_QUOTA_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    private final Connection conn;
    private final Configuration conf;
    private final MetricsMaster metrics;
    private final FileSystem fs;

    public SnapshotQuotaObserverChore(HMaster master, MetricsMaster metrics) {
        this(master.getConnection(), master.getConfiguration(), master.getFileSystem(), master, metrics);
    }

    SnapshotQuotaObserverChore(Connection conn, Configuration conf, FileSystem fs, Stoppable stopper, MetricsMaster metrics) {
        super(QuotaObserverChore.class.getSimpleName(), stopper, SnapshotQuotaObserverChore.getPeriod(conf), SnapshotQuotaObserverChore.getInitialDelay(conf), SnapshotQuotaObserverChore.getTimeUnit(conf));
        this.conn = conn;
        this.conf = conf;
        this.metrics = metrics;
        this.fs = fs;
    }

    protected void chore() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Computing sizes of snapshots for quota management.");
            }
            long start = System.nanoTime();
            this._chore();
            if (null != this.metrics) {
                this.metrics.incrementSnapshotObserverTime((System.nanoTime() - start) / 1000000L);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to compute the size of snapshots, will retry", (Throwable)e);
        }
    }

    void _chore() throws IOException {
        long start = System.nanoTime();
        Multimap<TableName, String> snapshotsToComputeSize = this.getSnapshotsToComputeSize();
        if (null != this.metrics) {
            this.metrics.incrementSnapshotFetchTime((System.nanoTime() - start) / 1000000L);
        }
        this.pruneTableSnapshots(snapshotsToComputeSize);
        this.pruneNamespaceSnapshots(snapshotsToComputeSize);
        Map<String, Long> namespaceSnapshotSizes = this.computeSnapshotSizes(snapshotsToComputeSize);
        this.persistSnapshotSizesForNamespaces(namespaceSnapshotSizes);
    }

    void pruneTableSnapshots(Multimap<TableName, String> snapshotsToComputeSize) throws IOException {
        Multimap existingSnapshotEntries = QuotaTableUtil.getTableSnapshots((Connection)this.conn);
        HashMultimap snapshotEntriesToRemove = HashMultimap.create();
        for (Map.Entry entry : existingSnapshotEntries.asMap().entrySet()) {
            TableName tn = (TableName)entry.getKey();
            HashSet setOfSnapshots = new HashSet((Collection)entry.getValue());
            for (String snapshot : snapshotsToComputeSize.get((Object)tn)) {
                setOfSnapshots.remove(snapshot);
            }
            for (String snapshot : setOfSnapshots) {
                snapshotEntriesToRemove.put((Object)tn, (Object)snapshot);
            }
        }
        this.removeExistingTableSnapshotSizes((Multimap<TableName, String>)snapshotEntriesToRemove);
    }

    void pruneNamespaceSnapshots(Multimap<TableName, String> snapshotsToComputeSize) throws IOException {
        Set existingSnapshotEntries = QuotaTableUtil.getNamespaceSnapshots((Connection)this.conn);
        for (TableName tableName : snapshotsToComputeSize.keySet()) {
            existingSnapshotEntries.remove(tableName.getNamespaceAsString());
        }
        this.removeExistingNamespaceSnapshotSizes(existingSnapshotEntries);
    }

    /*
     * Exception decompiling
     */
    Multimap<TableName, String> getSnapshotsToComputeSize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Multimap<TableName, String> getSnapshotsFromTables(Admin admin, Set<TableName> tablesToFetchSnapshotsFrom) throws IOException {
        HashMultimap snapshotsToCompute = HashMultimap.create();
        for (SnapshotDescription sd : admin.listSnapshots()) {
            TableName tn = sd.getTableName();
            if (!tablesToFetchSnapshotsFrom.contains(tn)) continue;
            snapshotsToCompute.put((Object)tn, (Object)sd.getName());
        }
        return snapshotsToCompute;
    }

    Map<String, Long> computeSnapshotSizes(Multimap<TableName, String> snapshotsToComputeSize) throws IOException {
        HashMap<String, Long> snapshotSizesByNamespace = new HashMap<String, Long>();
        long start = System.nanoTime();
        for (Map.Entry entry : snapshotsToComputeSize.asMap().entrySet()) {
            TableName tn = (TableName)entry.getKey();
            Collection snapshotNames = (Collection)entry.getValue();
            FileArchiverNotifier notifier = this.getNotifierForTable(tn);
            long totalSnapshotSize = notifier.computeAndStoreSnapshotSizes(snapshotNames);
            snapshotSizesByNamespace.merge(tn.getNamespaceAsString(), totalSnapshotSize, Long::sum);
        }
        if (this.metrics != null) {
            this.metrics.incrementSnapshotSizeComputationTime((System.nanoTime() - start) / 1000000L);
        }
        return snapshotSizesByNamespace;
    }

    FileArchiverNotifier getNotifierForTable(TableName tn) {
        return FileArchiverNotifierFactoryImpl.getInstance().get(this.conn, this.conf, this.fs, tn);
    }

    void persistSnapshotSizesForNamespaces(Map<String, Long> snapshotSizesByNamespace) throws IOException {
        try (Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);){
            quotaTable.put(snapshotSizesByNamespace.entrySet().stream().map(e -> QuotaTableUtil.createPutForNamespaceSnapshotSize((String)((String)e.getKey()), (long)((Long)e.getValue()))).collect(Collectors.toList()));
        }
    }

    void removeExistingTableSnapshotSizes(Multimap<TableName, String> snapshotEntriesToRemove) throws IOException {
        this.removeExistingSnapshotSizes(QuotaTableUtil.createDeletesForExistingTableSnapshotSizes(snapshotEntriesToRemove));
    }

    void removeExistingNamespaceSnapshotSizes(Set<String> snapshotEntriesToRemove) throws IOException {
        this.removeExistingSnapshotSizes(QuotaTableUtil.createDeletesForExistingNamespaceSnapshotSizes(snapshotEntriesToRemove));
    }

    void removeExistingSnapshotSizes(List<Delete> deletes) throws IOException {
        try (Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);){
            quotaTable.delete(deletes);
        }
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(SNAPSHOT_QUOTA_CHORE_PERIOD_KEY, 300000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(SNAPSHOT_QUOTA_CHORE_DELAY_KEY, 60000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(SNAPSHOT_QUOTA_CHORE_TIMEUNIT_KEY, SNAPSHOT_QUOTA_CHORE_TIMEUNIT_DEFAULT));
    }
}

