/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.StreamingHttpClientRegistry;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.reactor.http.client.BridgedReactorStreamingHttpClient;
import io.micronaut.reactor.http.client.ReactorStreamingHttpClient;

@Factory
public class ReactorHttpClientFactory {
    private final StreamingHttpClientRegistry<?> clientRegistry;

    public ReactorHttpClientFactory(StreamingHttpClientRegistry<?> clientRegistry) {
        this.clientRegistry = clientRegistry;
    }

    @Bean
    @Secondary
    protected ReactorStreamingHttpClient streamingHttpClient(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable LoadBalancer loadBalancer, @Parameter @Nullable HttpClientConfiguration configuration, @NonNull BeanContext beanContext) {
        return new BridgedReactorStreamingHttpClient(this.clientRegistry.resolveStreamingHttpClient(injectionPoint, loadBalancer, configuration, beanContext));
    }
}

