/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.bifromq.basekv.InProcStores;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVRangeSetting {
    @Generated
    private transient int $hashCodeCache;
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KVRangeSetting.class);
    private final Any fact;
    private final String clusterId;
    private final KVRangeId id;
    private final long ver;
    private final Boundary boundary;
    private final String leader;
    private final List<String> allQueryReadyReplicas;
    private final List<String> inProcReplicas;
    private volatile Object factObject;

    public KVRangeSetting(String clusterId, String leaderStoreId, Map<String, KVRangeDescriptor> currentReplicas) {
        assert (currentReplicas.containsKey(leaderStoreId)) : "replicas doesn't contain leader store";
        KVRangeDescriptor leaderDesc = currentReplicas.get(leaderStoreId);
        this.clusterId = clusterId;
        this.id = leaderDesc.getId();
        this.ver = leaderDesc.getVer();
        this.boundary = leaderDesc.getBoundary();
        this.leader = leaderStoreId;
        this.fact = leaderDesc.getFact();
        TreeSet<String> allQueryReadyReplicas = new TreeSet<String>();
        TreeSet<String> inProcReplicas = new TreeSet<String>();
        HashSet allVoters = Sets.newHashSet((Iterable)Iterables.concat((Iterable)leaderDesc.getConfig().getVotersList(), (Iterable)leaderDesc.getConfig().getNextVotersList()));
        for (String v : allVoters) {
            if (leaderDesc.getSyncStateMap().get(v) != RaftNodeSyncState.Replicating) continue;
            if (this.isReadyForQuery(v, currentReplicas)) {
                allQueryReadyReplicas.add(v);
            }
            if (!InProcStores.getInProcStores((String)clusterId).contains(v)) continue;
            inProcReplicas.add(v);
        }
        Sets.SetView allLearners = Sets.union((Set)Sets.newHashSet((Iterable)Iterables.concat((Iterable)leaderDesc.getConfig().getLearnersList(), (Iterable)leaderDesc.getConfig().getNextLearnersList())), (Set)allVoters);
        for (String l : allLearners) {
            if (leaderDesc.getSyncStateMap().get(l) != RaftNodeSyncState.Replicating) continue;
            if (this.isReadyForQuery(l, currentReplicas)) {
                allQueryReadyReplicas.add(l);
            }
            if (!InProcStores.getInProcStores((String)clusterId).contains(l)) continue;
            inProcReplicas.add(l);
        }
        this.allQueryReadyReplicas = Collections.unmodifiableList(Lists.newArrayList(allQueryReadyReplicas));
        this.inProcReplicas = Collections.unmodifiableList(Lists.newArrayList(inProcReplicas));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Message> Optional<T> getFact(Class<T> factType) {
        if (this.factObject == null) {
            KVRangeSetting kVRangeSetting = this;
            synchronized (kVRangeSetting) {
                if (this.factObject == null) {
                    try {
                        if (!this.fact.is(factType)) {
                            return Optional.empty();
                        }
                        this.factObject = this.fact.unpack(factType);
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.error("parse fact error", (Throwable)e);
                        return Optional.empty();
                    }
                }
            }
        }
        return Optional.of((Message)this.factObject);
    }

    public Optional<String> inProcQueryReadyReplica() {
        if (!this.inProcReplicas.isEmpty()) {
            if (this.inProcReplicas.size() == 1 && this.allQueryReadyReplicas.contains(this.inProcReplicas.get(0))) {
                return Optional.of(this.inProcReplicas.get(0));
            }
            return this.allQueryReadyReplicas.stream().filter(this.inProcReplicas::contains).findFirst();
        }
        return Optional.empty();
    }

    public Optional<String> getQueryReadyReplica(int seq) {
        if (this.allQueryReadyReplicas.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.allQueryReadyReplicas.get(seq % this.allQueryReadyReplicas.size()));
    }

    public Optional<String> randomReplicaForQuery() {
        if (!this.inProcReplicas.isEmpty() && this.inProcReplicas.size() == 1 && this.allQueryReadyReplicas.contains(this.inProcReplicas.get(0))) {
            return Optional.of(this.inProcReplicas.get(0));
        }
        if (this.allQueryReadyReplicas.isEmpty()) {
            return Optional.empty();
        }
        if (this.allQueryReadyReplicas.size() == 1) {
            return Optional.of(this.allQueryReadyReplicas.get(0));
        }
        return Optional.of(this.allQueryReadyReplicas.get(ThreadLocalRandom.current().nextInt(this.allQueryReadyReplicas.size())));
    }

    private boolean isReadyForQuery(String storeId, Map<String, KVRangeDescriptor> descMap) {
        KVRangeDescriptor desc = descMap.get(storeId);
        if (desc == null) {
            return false;
        }
        return desc.getReadyForQuery();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KVRangeSetting)) {
            return false;
        }
        KVRangeSetting other = (KVRangeSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.ver() != other.ver()) {
            return false;
        }
        Any this$fact = this.fact;
        Any other$fact = other.fact;
        if (this$fact == null ? other$fact != null : !this$fact.equals(other$fact)) {
            return false;
        }
        String this$clusterId = this.clusterId;
        String other$clusterId = other.clusterId;
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        KVRangeId this$id = this.id();
        KVRangeId other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boundary this$boundary = this.boundary();
        Boundary other$boundary = other.boundary();
        if (this$boundary == null ? other$boundary != null : !this$boundary.equals(other$boundary)) {
            return false;
        }
        String this$leader = this.leader();
        String other$leader = other.leader();
        if (this$leader == null ? other$leader != null : !this$leader.equals(other$leader)) {
            return false;
        }
        List<String> this$allQueryReadyReplicas = this.allQueryReadyReplicas;
        List<String> other$allQueryReadyReplicas = other.allQueryReadyReplicas;
        if (this$allQueryReadyReplicas == null ? other$allQueryReadyReplicas != null : !((Object)this$allQueryReadyReplicas).equals(other$allQueryReadyReplicas)) {
            return false;
        }
        List<String> this$inProcReplicas = this.inProcReplicas;
        List<String> other$inProcReplicas = other.inProcReplicas;
        return !(this$inProcReplicas == null ? other$inProcReplicas != null : !((Object)this$inProcReplicas).equals(other$inProcReplicas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KVRangeSetting;
    }

    @Generated
    public int hashCode() {
        if (this.$hashCodeCache != 0) {
            return this.$hashCodeCache;
        }
        int PRIME = 59;
        int result = 1;
        long $ver = this.ver();
        result = result * 59 + (int)($ver >>> 32 ^ $ver);
        Any $fact = this.fact;
        result = result * 59 + ($fact == null ? 43 : $fact.hashCode());
        String $clusterId = this.clusterId;
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        KVRangeId $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boundary $boundary = this.boundary();
        result = result * 59 + ($boundary == null ? 43 : $boundary.hashCode());
        String $leader = this.leader();
        result = result * 59 + ($leader == null ? 43 : $leader.hashCode());
        List<String> $allQueryReadyReplicas = this.allQueryReadyReplicas;
        result = result * 59 + ($allQueryReadyReplicas == null ? 43 : ((Object)$allQueryReadyReplicas).hashCode());
        List<String> $inProcReplicas = this.inProcReplicas;
        if ((result = result * 59 + ($inProcReplicas == null ? 43 : ((Object)$inProcReplicas).hashCode())) == 0) {
            result = Integer.MIN_VALUE;
        }
        this.$hashCodeCache = result;
        return result;
    }

    @Generated
    public String toString() {
        return "KVRangeSetting(fact=" + String.valueOf(this.fact) + ", clusterId=" + this.clusterId + ", id=" + String.valueOf(this.id()) + ", ver=" + this.ver() + ", boundary=" + String.valueOf(this.boundary()) + ", leader=" + this.leader() + ", allQueryReadyReplicas=" + String.valueOf(this.allQueryReadyReplicas) + ", inProcReplicas=" + String.valueOf(this.inProcReplicas) + ", factObject=" + String.valueOf(this.factObject) + ")";
    }

    @Generated
    public KVRangeId id() {
        return this.id;
    }

    @Generated
    public long ver() {
        return this.ver;
    }

    @Generated
    public Boundary boundary() {
        return this.boundary;
    }

    @Generated
    public String leader() {
        return this.leader;
    }
}

