/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.utils;

import com.google.protobuf.ByteString;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.basekv.utils.EffectiveRoute;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class DescriptorUtil {
    public static NavigableMap<Long, Set<KVRangeStoreDescriptor>> organizeByEpoch(Set<KVRangeStoreDescriptor> storeDescriptors) {
        TreeMap<Long, Set<KVRangeStoreDescriptor>> epochMap = new TreeMap<Long, Set<KVRangeStoreDescriptor>>();
        HashMap<Long, Map> storeDescBuilderByEpoch = new HashMap<Long, Map>();
        for (KVRangeStoreDescriptor storeDescriptor : storeDescriptors) {
            for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                long epoch2 = rangeDescriptor.getId().getEpoch();
                ((KVRangeStoreDescriptor.Builder)storeDescBuilderByEpoch.computeIfAbsent(epoch2, e -> storeDescriptors.stream().collect(Collectors.toMap(KVRangeStoreDescriptor::getId, k -> k.toBuilder().clearRanges()))).get(storeDescriptor.getId())).addRanges(rangeDescriptor);
            }
        }
        storeDescBuilderByEpoch.forEach((epoch, storeDescBuilderMap) -> {
            Set storeDescSet = storeDescBuilderMap.values().stream().map(KVRangeStoreDescriptor.Builder::build).collect(Collectors.toSet());
            epochMap.put((Long)epoch, storeDescSet);
        });
        return epochMap;
    }

    public static Optional<EffectiveEpoch> getEffectiveEpoch(Set<KVRangeStoreDescriptor> storeDescriptors) {
        NavigableMap<Long, Set<KVRangeStoreDescriptor>> storeDescriptorsByEpoch = DescriptorUtil.organizeByEpoch(storeDescriptors);
        if (storeDescriptorsByEpoch.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry<Long, Set<KVRangeStoreDescriptor>> oldestEpoch = storeDescriptorsByEpoch.firstEntry();
        return Optional.of(new EffectiveEpoch(oldestEpoch.getKey(), oldestEpoch.getValue()));
    }

    public static EffectiveRoute getEffectiveRoute(EffectiveEpoch effectiveEpoch) {
        HashMap<KVRangeId, Map<String, KVRangeDescriptor>> rangeMap = new HashMap<KVRangeId, Map<String, KVRangeDescriptor>>();
        for (KVRangeStoreDescriptor storeDescriptor : effectiveEpoch.storeDescriptors()) {
            for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                rangeMap.computeIfAbsent(rangeDescriptor.getId(), k -> new HashMap()).put(storeDescriptor.getId(), rangeDescriptor);
            }
        }
        return new EffectiveRoute(effectiveEpoch.epoch(), DescriptorUtil.getRangeLeaders(rangeMap));
    }

    public static NavigableMap<Boundary, RangeLeader> getRangeLeaders(Map<KVRangeId, Map<String, KVRangeDescriptor>> rangeMap) {
        Map.Entry firstEntry;
        TreeSet<RangeLeader> firstRangeLeaders = new TreeSet<RangeLeader>(Comparator.comparingLong(l -> l.descriptor().getId().getId()));
        TreeMap<ByteString, NavigableSet> sortedLeaderRanges = new TreeMap<ByteString, NavigableSet>(ByteString.unsignedLexicographicalComparator());
        for (KVRangeId rangeId : rangeMap.keySet()) {
            Map<String, KVRangeDescriptor> replicas = rangeMap.get(rangeId);
            for (String storeId : replicas.keySet()) {
                KVRangeDescriptor rangeDescriptor = replicas.get(storeId);
                if (rangeDescriptor.getRole() == RaftNodeStatus.Leader) {
                    switch (rangeDescriptor.getState()) {
                        case Normal: 
                        case ConfigChanging: 
                        case PreparedMerging: 
                        case WaitingForMerge: {
                            ByteString startKey = BoundaryUtil.startKey(rangeDescriptor.getBoundary());
                            if (startKey == null) {
                                firstRangeLeaders.add(new RangeLeader(storeId, rangeDescriptor));
                                break;
                            }
                            sortedLeaderRanges.computeIfAbsent(startKey, k -> new TreeSet<RangeLeader>(Comparator.comparingLong(l -> l.descriptor().getId().getId()))).add(new RangeLeader(storeId, rangeDescriptor));
                            break;
                        }
                    }
                }
            }
        }
        TreeMap<Boundary, RangeLeader> effectiveRouteMap = new TreeMap<Boundary, RangeLeader>(BoundaryUtil::compare);
        RangeLeader prev = (RangeLeader)firstRangeLeaders.pollFirst();
        if (prev == null && (firstEntry = sortedLeaderRanges.firstEntry()) != null) {
            prev = (RangeLeader)((NavigableSet)firstEntry.getValue()).pollFirst();
        }
        while (prev != null) {
            effectiveRouteMap.put(prev.descriptor().getBoundary(), prev);
            ByteString endKey = BoundaryUtil.endKey(prev.descriptor().getBoundary());
            if (endKey == null) break;
            Map.Entry next = sortedLeaderRanges.ceilingEntry(endKey);
            if (next != null) {
                prev = (RangeLeader)((NavigableSet)next.getValue()).pollFirst();
                continue;
            }
            prev = null;
        }
        return effectiveRouteMap;
    }
}

