/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store.balance;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.impl.RangeSplitBalancer;
import org.apache.bifromq.retain.store.spi.IRetainStoreBalancerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSplitBalancerFactory
implements IRetainStoreBalancerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangeSplitBalancerFactory.class);
    private static final String MAX_RANGES_PER_STORE = "maxRangesPerStore";
    private static final String MAX_CPU_USAGE = "maxCPUUsage";
    private static final String MAX_IO_DENSITY = "maxIODensity";
    private static final String IO_NANOS_LIMITS = "ioNanosLimit";
    private static final int DEFAULT_MAX_RANGES_PER_STORE = EnvProvider.INSTANCE.availableProcessors() / 4;
    private static final double DEFAULT_MAX_CPU_USAGE = 0.8;
    private static final int DEFAULT_MAX_IO_DENSITY = 100;
    private static final long DEFAULT_IO_NANOS_LIMITS = 30000L;
    private int maxRangesPerStore;
    private double maxCPUUsage;
    private int maxIODensity;
    private long ioNanosLimits;

    public void init(Struct config) {
        this.maxRangesPerStore = (int)config.getFieldsOrDefault(MAX_RANGES_PER_STORE, Value.newBuilder().setNumberValue((double)DEFAULT_MAX_RANGES_PER_STORE).build()).getNumberValue();
        if (this.maxRangesPerStore < 1) {
            this.maxRangesPerStore = DEFAULT_MAX_RANGES_PER_STORE;
            log.warn("Invalid max ranges per store config {}, use default {}", (Object)this.maxRangesPerStore, (Object)DEFAULT_MAX_RANGES_PER_STORE);
        }
        this.maxCPUUsage = config.getFieldsOrDefault(MAX_CPU_USAGE, Value.newBuilder().setNumberValue(0.8).build()).getNumberValue();
        if (this.maxCPUUsage < 0.0 || this.maxCPUUsage > 1.0) {
            this.maxCPUUsage = 0.8;
            log.warn("Invalid max cpu usage config {}, use default {}", (Object)this.maxCPUUsage, (Object)0.8);
        }
        this.maxIODensity = (int)config.getFieldsOrDefault(MAX_IO_DENSITY, Value.newBuilder().setNumberValue(100.0).build()).getNumberValue();
        if (this.maxIODensity < 1 || this.maxIODensity > 1000) {
            this.maxIODensity = 100;
            log.warn("Invalid max io density config {}, use default {}", (Object)this.maxIODensity, (Object)100);
        }
        this.ioNanosLimits = (long)config.getFieldsOrDefault(IO_NANOS_LIMITS, Value.newBuilder().setNumberValue(30000.0).build()).getNumberValue();
        if (this.ioNanosLimits < 1L || this.ioNanosLimits > 100000L) {
            this.ioNanosLimits = 30000L;
            log.warn("Invalid io nanos limits config {}, use default {}", (Object)this.ioNanosLimits, (Object)30000L);
        }
    }

    public StoreBalancer newBalancer(String clusterId, String localStoreId) {
        return new RangeSplitBalancer(clusterId, localStoreId, "kv_io_mutation", this.maxRangesPerStore, this.maxCPUUsage, this.maxIODensity, this.ioNanosLimits);
    }
}

