/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;

class WebHookBasedSettingProvider
implements ISettingProvider {
    private final URI webhookURI;
    private final HttpClient httpClient;

    WebHookBasedSettingProvider(URI webhookURI) {
        this.webhookURI = webhookURI;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public <R> R provide(Setting setting, String tenantId) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.webhookURI).GET().timeout(Duration.ofSeconds(5L)).header("tenant_id", tenantId).header("setting_name", setting.name()).build();
        Object val = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                try {
                    if (setting.valueType == Integer.class) {
                        return Integer.valueOf(Integer.parseInt((String)response.body()));
                    }
                    if (setting.valueType == Long.class) {
                        return Long.valueOf(Long.parseLong((String)response.body()));
                    }
                    if (setting.valueType == Boolean.class) {
                        return Boolean.valueOf(Boolean.parseBoolean((String)response.body()));
                    }
                    return null;
                }
                catch (Throwable e) {
                    return null;
                }
            }
            return null;
        })).thenApply(r -> setting.isValid(r, tenantId) ? r : null)).exceptionally(e -> {
            System.out.println("Failed to call webhook: " + e.getMessage());
            return null;
        })).join();
        return (R)val;
    }
}

