/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;

abstract class PeerLogReplicatorState {
    protected final String peerId;
    protected final RaftConfig config;
    protected final IRaftStateStore stateStorage;
    protected final Logger logger;
    protected long matchIndex;
    protected long nextIndex;

    PeerLogReplicatorState(String peerId, RaftConfig config, IRaftStateStore stateStorage, long matchIndex, long nextIndex, Logger logger) {
        this.peerId = peerId;
        this.config = config;
        this.stateStorage = stateStorage;
        this.matchIndex = matchIndex;
        this.nextIndex = nextIndex;
        this.logger = logger;
        logger.debug("Peer[{}] tracker[matchIndex:{},nextIndex:{},state:{}] initialized", new Object[]{peerId, matchIndex, nextIndex, this.state()});
    }

    public final long matchIndex() {
        return this.matchIndex;
    }

    public final long nextIndex() {
        return this.nextIndex;
    }

    public abstract RaftNodeSyncState state();

    public abstract PeerLogReplicatorState tick();

    public abstract long catchupRate();

    public abstract boolean pauseReplicating();

    public abstract boolean needHeartbeat();

    public abstract PeerLogReplicatorState backoff(long var1, long var3);

    public abstract PeerLogReplicatorState confirmMatch(long var1);

    public abstract PeerLogReplicatorState replicateTo(long var1);
}

