/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.QuorumTracker;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.RaftNodeState;
import org.apache.bifromq.basekv.raft.RaftNodeStateFollower;
import org.apache.bifromq.basekv.raft.RaftNodeStateLeader;
import org.apache.bifromq.basekv.raft.exception.ClusterConfigChangeException;
import org.apache.bifromq.basekv.raft.exception.DropProposalException;
import org.apache.bifromq.basekv.raft.exception.LeaderTransferException;
import org.apache.bifromq.basekv.raft.exception.ReadIndexException;
import org.apache.bifromq.basekv.raft.exception.RecoveryException;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.RequestPreVote;
import org.apache.bifromq.basekv.raft.proto.RequestVote;

class RaftNodeStateCandidate
extends RaftNodeState {
    private final QuorumTracker voteTracker;
    private final QuorumTracker preVoteTracker;
    private int electionElapsedTick;
    private int randomElectionTimeoutTick = this.randomizeElectionTimeoutTick();
    private boolean checkRecoverable = false;
    private CompletableFuture<Void> recoveryTask;

    RaftNodeStateCandidate(long term, long commitIndex, RaftConfig config, IRaftStateStore stateStorage, LinkedHashMap<Long, RaftNodeState.ProposeTask> uncommittedProposals, IRaftNode.IRaftMessageSender sender, IRaftNode.IRaftEventListener listener, IRaftNode.ISnapshotInstaller installer, RaftNodeState.OnSnapshotInstalled onSnapshotInstalled, String ... tags) {
        super(term, commitIndex, config, stateStorage, uncommittedProposals, sender, listener, installer, onSnapshotInstalled, tags);
        this.voteTracker = new QuorumTracker(stateStorage.latestClusterConfig(), this.log);
        this.preVoteTracker = new QuorumTracker(stateStorage.latestClusterConfig(), this.log);
    }

    @Override
    public RaftNodeStatus getState() {
        return RaftNodeStatus.Candidate;
    }

    @Override
    public String currentLeader() {
        return null;
    }

    @Override
    RaftNodeState stepDown() {
        return this;
    }

    @Override
    void recover(CompletableFuture<Void> onDone) {
        if (!this.promotable()) {
            onDone.completeExceptionally(RecoveryException.notVoter());
        } else if (this.recoveryTask == null) {
            this.checkRecoverable = false;
            this.recoveryTask = onDone;
        } else {
            onDone.completeExceptionally(RecoveryException.recoveryInProgress());
        }
    }

    @Override
    RaftNodeState tick() {
        ++this.electionElapsedTick;
        if (this.promotable() && this.electionElapsedTick >= this.randomElectionTimeoutTick) {
            this.randomElectionTimeoutTick = this.randomizeElectionTimeoutTick();
            this.log.debug("No leader elected, reset election timeout[{}]", (Object)this.randomElectionTimeoutTick);
            if (this.recoveryTask != null && this.checkRecoverable) {
                this.tryRecovery();
            }
            return this.campaign(this.config.isPreVote(), false);
        }
        return this;
    }

    @Override
    void propose(ByteString fsmCmd, CompletableFuture<Long> onDone) {
        onDone.completeExceptionally(DropProposalException.noLeader());
    }

    @Override
    RaftNodeState stableTo(long stabledIndex) {
        return this;
    }

    @Override
    void readIndex(CompletableFuture<Long> onDone) {
        onDone.completeExceptionally(ReadIndexException.noLeader());
    }

    @Override
    RaftNodeState receive(String fromPeer, RaftMessage message) {
        this.log.trace("Receive[{}] from {}", (Object)message, (Object)fromPeer);
        RaftNodeState nextState = this;
        if (message.getTerm() > this.currentTerm()) {
            block0 : switch (message.getMessageTypeCase()) {
                case REQUESTPREVOTE: {
                    this.handlePreVote(fromPeer, message.getTerm(), message.getRequestPreVote());
                    break;
                }
                case REQUESTPREVOTEREPLY: {
                    this.preVoteTracker.poll(fromPeer, message.getRequestPreVoteReply().getVoteCouldGranted());
                    QuorumTracker.JointVoteResult preVoteResult = this.preVoteTracker.tally();
                    switch (preVoteResult.result) {
                        case Won: {
                            this.finishRecoveryTask(RecoveryException.notLostQuorum());
                            this.log.debug("Pre-Election won[{}] and started formal campaign", (Object)preVoteResult);
                            nextState = this.campaign(false, false);
                            break block0;
                        }
                        case Lost: {
                            this.finishRecoveryTask(RecoveryException.notLostQuorum());
                            this.log.debug("Pre-Election lost[{}] and stay as candidate", (Object)preVoteResult);
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    this.log.debug("Transited to follower due to higher term[{}] found", (Object)message.getTerm());
                    this.finishRecoveryTask(RecoveryException.abort());
                    nextState = new RaftNodeStateFollower(message.getTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
                    nextState.receive(fromPeer, message);
                    break;
                }
            }
        } else {
            if (message.getTerm() < this.currentTerm()) {
                this.handleLowTermMessage(fromPeer, message);
                return nextState;
            }
            switch (message.getMessageTypeCase()) {
                case APPENDENTRIES: 
                case INSTALLSNAPSHOT: {
                    String leader = message.getMessageTypeCase() == RaftMessage.MessageTypeCase.APPENDENTRIES ? message.getAppendEntries().getLeaderId() : message.getInstallSnapshot().getLeaderId();
                    this.log.debug("Transited to follower to handle request from newly elected leader[{}]", (Object)leader);
                    this.finishRecoveryTask(RecoveryException.notLostQuorum());
                    nextState = new RaftNodeStateFollower(message.getTerm(), this.commitIndex, leader, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
                    nextState.receive(fromPeer, message);
                    break;
                }
                case REQUESTVOTEREPLY: {
                    this.voteTracker.poll(fromPeer, message.getRequestVoteReply().getVoteGranted());
                    nextState = this.tallyVotes();
                    break;
                }
                case REQUESTVOTE: {
                    this.log.debug("Rejected vote for candidate[{}]", (Object)fromPeer);
                    this.sendRequestVoteReply(fromPeer, this.currentTerm(), false);
                    break;
                }
            }
        }
        return nextState;
    }

    @Override
    void transferLeadership(String newLeader, CompletableFuture<Void> onDone) {
        onDone.completeExceptionally(LeaderTransferException.noLeader());
    }

    @Override
    void changeClusterConfig(String correlateId, Set<String> newVoters, Set<String> newLearners, CompletableFuture<Void> onDone) {
        onDone.completeExceptionally(ClusterConfigChangeException.noLeader());
    }

    @Override
    void onSnapshotRestored(ByteString requested, ByteString installed, Throwable ex, CompletableFuture<Void> onDone) {
        onDone.complete(null);
    }

    @Override
    public void stop() {
        super.stop();
        this.finishRecoveryTask(RecoveryException.cancelled());
    }

    RaftNodeState campaign(boolean preVote, boolean transferLeader) {
        if (this.recoveryTask != null && !this.checkRecoverable) {
            this.checkRecoverable = true;
        }
        this.electionElapsedTick = 0;
        if (!this.promotable()) {
            return this;
        }
        this.voteTracker.reset();
        this.preVoteTracker.reset();
        long campaignTerm = this.currentTerm() + 1L;
        if (transferLeader || !preVote) {
            this.stateStorage.saveTerm(this.currentTerm() + 1L);
        }
        long lastLogTerm = this.stateStorage.latestSnapshot().getTerm();
        long lastLogIndex = this.stateStorage.latestSnapshot().getIndex();
        if (this.stateStorage.lastIndex() >= this.stateStorage.firstIndex()) {
            LogEntry lastEntry = this.stateStorage.entryAt(this.stateStorage.lastIndex()).get();
            lastLogIndex = lastEntry.getIndex();
            lastLogTerm = lastEntry.getTerm();
        }
        RaftMessage.Builder msgBuilder = RaftMessage.newBuilder().setTerm(campaignTerm);
        this.log.debug("Started leadership campaign for term[{}] with pre-vote[{}] and transferLeader[{}]", new Object[]{campaignTerm, preVote, transferLeader});
        if (transferLeader || !preVote) {
            this.voteTracker.poll(this.stateStorage.local(), true);
            msgBuilder.setRequestVote(RequestVote.newBuilder().setCandidateId(this.stateStorage.local()).setLastLogIndex(lastLogIndex).setLastLogTerm(lastLogTerm).setLeaderTransfer(transferLeader).build());
        } else {
            this.preVoteTracker.poll(this.stateStorage.local(), true);
            msgBuilder.setRequestPreVote(RequestPreVote.newBuilder().setCandidateId(this.stateStorage.local()).setLastLogIndex(lastLogIndex).setLastLogTerm(lastLogTerm).build());
        }
        HashMap<String, List<RaftMessage>> requests = new HashMap<String, List<RaftMessage>>();
        Set<String> peers = this.remoteVoters();
        if (!peers.isEmpty()) {
            List<RaftMessage> msg = Collections.singletonList(msgBuilder.build());
            peers.forEach(peer -> requests.put((String)peer, msg));
            this.submitRaftMessages(requests);
        }
        if (transferLeader || !preVote) {
            return this.tallyVotes();
        }
        QuorumTracker.JointVoteResult preVoteResult = this.preVoteTracker.tally();
        switch (preVoteResult.result) {
            case Won: {
                this.log.debug("Pre-Election won[{}] and started formal campaign", (Object)preVoteResult);
                this.finishRecoveryTask(RecoveryException.notLostQuorum());
                return this.campaign(false, false);
            }
            case Lost: {
                this.log.debug("Pre-Election lost[{}] and transited to follower", (Object)preVoteResult);
                this.finishRecoveryTask(RecoveryException.notLostQuorum());
                return new RaftNodeStateFollower(this.currentTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
            }
        }
        return this;
    }

    private void tryRecovery() {
        QuorumTracker quorumTracker = this.config.isPreVote() ? this.preVoteTracker : this.voteTracker;
        Set<String> allVoters = this.voters();
        QuorumTracker.VoteGroupResult tallyResult = quorumTracker.tally(allVoters);
        if (tallyResult.no == 0) {
            ClusterConfig recoveryConfig = ClusterConfig.newBuilder().addAllVoters((Iterable)allVoters.stream().filter(v -> quorumTracker.tally((String)v) == QuorumTracker.TallyResult.Yes).collect(Collectors.toSet())).build();
            long lastLogTerm = this.stateStorage.latestSnapshot().getTerm();
            long lastLogIndex = this.stateStorage.latestSnapshot().getIndex();
            if (this.stateStorage.lastIndex() >= this.stateStorage.firstIndex()) {
                LogEntry lastEntry = this.stateStorage.entryAt(this.stateStorage.lastIndex()).get();
                lastLogIndex = lastEntry.getIndex();
                lastLogTerm = lastEntry.getTerm();
            }
            LogEntry targetConfigEntry = LogEntry.newBuilder().setTerm(lastLogTerm).setIndex(lastLogIndex + 1L).setConfig(recoveryConfig).build();
            this.log.info("Recover cluster config to {}", (Object)recoveryConfig.getVotersList());
            this.stateStorage.append(Collections.singletonList(targetConfigEntry), true);
            this.preVoteTracker.refresh(recoveryConfig);
            this.voteTracker.refresh(recoveryConfig);
            this.finishRecoveryTask(null);
        } else {
            this.finishRecoveryTask(RecoveryException.notQualify());
        }
    }

    private void finishRecoveryTask(RecoveryException ex) {
        if (this.recoveryTask != null) {
            if (ex == null) {
                this.recoveryTask.complete(null);
            } else {
                this.recoveryTask.completeExceptionally(ex);
            }
            this.recoveryTask = null;
            this.checkRecoverable = false;
        }
    }

    private RaftNodeState tallyVotes() {
        QuorumTracker.JointVoteResult voteResult = this.voteTracker.tally();
        switch (voteResult.result) {
            case Won: {
                this.log.debug("Election won[{}] and stepped up to leader", (Object)voteResult);
                this.finishRecoveryTask(RecoveryException.notLostQuorum());
                return new RaftNodeStateLeader(this.currentTerm(), this.commitIndex, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
            }
            case Lost: {
                this.log.debug("Election lost[{}] and transited to follower", (Object)voteResult);
                this.finishRecoveryTask(RecoveryException.notLostQuorum());
                return new RaftNodeStateFollower(this.currentTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
            }
            case Pending: {
                this.log.debug("Election pending[{}]", (Object)voteResult);
            }
        }
        return this;
    }
}

