/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Counter;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDTInflater;
import org.apache.bifromq.basecrdt.store.NeighborMessage;
import org.apache.bifromq.basecrdt.store.proto.AckMessage;
import org.apache.bifromq.basecrdt.store.proto.DeltaMessage;
import org.apache.bifromq.basecrdt.util.Formatter;
import org.apache.bifromq.basecrdt.util.ProtoUtil;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

final class AntiEntropy {
    private final Logger log;
    private final ICausalCRDTInflater<?, ?> crdtInflater;
    private final ByteString localAddr;
    private final ByteString neighborAddr;
    private final ScheduledExecutorService executor;
    private final Subject<NeighborMessage> neighborMessageSubject;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final CompositeDisposable disposable = new CompositeDisposable();
    private final int maxEventsInDelta;
    private final Counter deltaMsgCounter;
    private final Counter deltaMsgBytesCounter;
    private volatile long lastInflationTs = 0L;
    private long neighborVer;
    private Map<ByteString, NavigableMap<Long, Long>> neighborLatticeIndex;
    private Map<ByteString, NavigableMap<Long, Long>> neighborHistoryIndex;
    private int resendCount = 0;
    private ScheduledFuture<?> resendTask = null;
    private long currentNeighborVer;
    private long currentInflationTs;
    private DeltaMessage currentDelta = null;
    private boolean lastSentHasReplacement = false;

    AntiEntropy(String storeId, ByteString localAddr, ByteString neighborAddr, ICausalCRDTInflater<?, ?> crdtInflater, Subject<NeighborMessage> neighborMessageSubject, ScheduledExecutorService executor, int maxEventsInDelta, Counter deltaMsgCounter, Counter deltaMsgBytesCounter) {
        this.log = MDCLogger.getLogger(AntiEntropy.class, (String[])new String[]{"store", storeId, "replica", Formatter.print(crdtInflater.id())});
        this.crdtInflater = crdtInflater;
        this.localAddr = localAddr;
        this.neighborAddr = neighborAddr;
        this.neighborMessageSubject = neighborMessageSubject;
        this.executor = executor;
        this.maxEventsInDelta = maxEventsInDelta;
        this.deltaMsgCounter = deltaMsgCounter;
        this.deltaMsgBytesCounter = deltaMsgBytesCounter;
        this.disposable.add(crdtInflater.getCRDT().inflation().subscribe(d -> {
            this.lastInflationTs = System.nanoTime();
            this.scheduleRun();
        }));
        this.scheduleRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateObservedNeighborHistory(long ver, Map<ByteString, NavigableMap<Long, Long>> latticeIndex, Map<ByteString, NavigableMap<Long, Long>> historyIndex) {
        if (this.canceled.get()) {
            return;
        }
        AntiEntropy antiEntropy = this;
        synchronized (antiEntropy) {
            if (ver > this.neighborVer) {
                this.neighborVer = ver;
                this.neighborLatticeIndex = latticeIndex;
                this.neighborHistoryIndex = historyIndex;
                this.scheduleRun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAck(AckMessage ack) {
        if (this.canceled.get()) {
            return;
        }
        AntiEntropy antiEntropy = this;
        synchronized (antiEntropy) {
            if (this.running.get() && this.currentDelta != null && ack.getSeqNo() == this.currentDelta.getSeqNo()) {
                this.currentDelta = null;
                if (this.resendTask != null) {
                    this.resendTask.cancel(false);
                }
                this.resendCount = 0;
                if (ack.getVer() > this.neighborVer) {
                    this.neighborVer = ack.getVer();
                    this.neighborLatticeIndex = ProtoUtil.to(ack.getLatticeEventsList());
                    this.neighborHistoryIndex = ProtoUtil.to(ack.getHistoryEventsList());
                }
                this.running.set(false);
                if (this.currentNeighborVer == 0L || this.lastInflationTs != this.currentInflationTs || ack.getVer() > this.currentNeighborVer || this.lastSentHasReplacement) {
                    this.scheduleRun();
                }
                this.lastSentHasReplacement = false;
                return;
            }
            if (ack.getVer() > this.neighborVer) {
                this.neighborVer = ack.getVer();
                this.neighborLatticeIndex = ProtoUtil.to(ack.getLatticeEventsList());
                this.neighborHistoryIndex = ProtoUtil.to(ack.getHistoryEventsList());
                if (!this.running.get()) {
                    this.scheduleRun();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.log.debug("Local[{}] cancel anti-entropy to neighbor[{}] ", Formatter.toPrintable(this.localAddr), Formatter.toPrintable(this.neighborAddr));
            this.disposable.dispose();
            this.canceled.set(true);
            AntiEntropy antiEntropy = this;
            synchronized (antiEntropy) {
                this.currentDelta = null;
                if (this.resendTask != null) {
                    this.resendTask.cancel(false);
                }
            }
        }
    }

    private void scheduleRun() {
        if (this.canceled.get()) {
            return;
        }
        if (this.running.compareAndSet(false, true)) {
            this.log.debug("Local[{}] start anti-entropy to neighbor[{}]", Formatter.toPrintable(this.localAddr), Formatter.toPrintable(this.neighborAddr));
            this.executor.execute(this::run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        if (this.canceled.get()) {
            return;
        }
        AntiEntropy antiEntropy = this;
        synchronized (antiEntropy) {
            this.currentNeighborVer = this.neighborVer;
            this.currentInflationTs = this.lastInflationTs;
            if (this.currentNeighborVer == 0L) {
                this.currentDelta = DeltaMessage.newBuilder().setSeqNo(HLC.INST.get()).addAllLatticeEvents(ProtoUtil.to(this.crdtInflater.latticeEvents())).addAllHistoryEvents(ProtoUtil.to(this.crdtInflater.historyEvents())).setVer(HLC.INST.get()).build();
                this.lastSentHasReplacement = false;
                this.send(this.currentDelta);
            } else {
                this.crdtInflater.delta(this.neighborLatticeIndex, this.neighborHistoryIndex, this.maxEventsInDelta).whenComplete((delta, e) -> {
                    AntiEntropy antiEntropy = this;
                    synchronized (antiEntropy) {
                        if (e != null) {
                            this.log.error("Local[{}] failed to calculate delta for neighbor[{}]", new Object[]{Formatter.toPrintable(this.localAddr), Formatter.toPrintable(this.neighborAddr), e});
                            this.running.set(false);
                            return;
                        }
                        if (delta.isPresent()) {
                            this.currentDelta = DeltaMessage.newBuilder().setSeqNo(HLC.INST.get()).addAllReplacement((Iterable)delta.get()).addAllLatticeEvents(ProtoUtil.to(this.crdtInflater.latticeEvents())).addAllHistoryEvents(ProtoUtil.to(this.crdtInflater.historyEvents())).setVer(HLC.INST.get()).build();
                            this.lastSentHasReplacement = true;
                            this.send(this.currentDelta);
                        } else {
                            this.currentDelta = null;
                            this.resendCount = 0;
                            this.running.set(false);
                            if (this.currentNeighborVer != this.neighborVer || this.currentInflationTs != this.lastInflationTs) {
                                this.scheduleRun();
                            }
                        }
                    }
                });
            }
        }
    }

    private void send(DeltaMessage deltaMessage) {
        this.log.trace("Local[{}] send delta to neighbor[{}]:\n{}", new Object[]{Formatter.toPrintable(this.localAddr), Formatter.toPrintable(this.neighborAddr), Formatter.toPrintable(deltaMessage)});
        this.emit(deltaMessage);
        this.scheduleResend(deltaMessage);
    }

    private void scheduleResend(DeltaMessage toResend) {
        if (this.canceled.get()) {
            return;
        }
        this.resendTask = this.executor.schedule(() -> this.resend(toResend), this.resendDelay(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resend(DeltaMessage toResend) {
        if (this.canceled.get()) {
            return;
        }
        AntiEntropy antiEntropy = this;
        synchronized (antiEntropy) {
            if (this.currentDelta == toResend) {
                this.log.trace("Local[{}] resend delta to neighbor[{}]:\n{}", new Object[]{Formatter.toPrintable(this.localAddr), Formatter.toPrintable(this.neighborAddr), Formatter.toPrintable(toResend)});
                this.emit(this.currentDelta);
                if (this.resendCount++ < 10) {
                    this.scheduleResend(toResend);
                } else {
                    this.log.debug("Local[{}] resend delta to neighbor[{}] exceed max resend count, try probing", Formatter.toPrintable(this.localAddr), Formatter.toPrintable(this.neighborAddr));
                    this.neighborVer = 0L;
                    this.currentDelta = null;
                    this.resendTask = null;
                    this.resendCount = 0;
                    this.running.set(false);
                    this.scheduleRun();
                }
            }
        }
    }

    private long resendDelay() {
        return ThreadLocalRandom.current().nextLong(500L, 2000L) * (long)(this.resendCount + 1);
    }

    private void emit(DeltaMessage delta) {
        this.deltaMsgCounter.increment();
        this.deltaMsgBytesCounter.increment((double)delta.getSerializedSize());
        this.neighborMessageSubject.onNext((Object)new NeighborMessage(delta, this.neighborAddr));
    }
}

