/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store.spi;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.util.List;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.retain.store.schema.KVSchemaUtil;
import org.apache.bifromq.util.TopicUtil;

public class SplitKey {
    public static Boundary tenantBoundary(String tenantId) {
        ByteString tenantBeginKey = KVSchemaUtil.tenantBeginKey((String)tenantId);
        return BoundaryUtil.toBoundary((ByteString)tenantBeginKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantBeginKey));
    }

    public static Boundary retainBucketBoundary(String tenantId, String topicPattern, byte bucket) {
        int idx = topicPattern.indexOf("+");
        if (idx < 0 || topicPattern.indexOf("+") != topicPattern.lastIndexOf("+")) {
            throw new IllegalArgumentException("Invalid topic pattern: " + topicPattern);
        }
        List topicLevels = TopicUtil.parse((String)topicPattern, (boolean)false);
        List prefixLevels = KVSchemaUtil.filterPrefix((List)topicLevels);
        ByteString splitKey = KVSchemaUtil.retainKeyPrefix((String)tenantId, (short)((short)topicLevels.size()), (List)prefixLevels).concat(UnsafeByteOperations.unsafeWrap((byte[])new byte[]{bucket}));
        return BoundaryUtil.toBoundary((ByteString)splitKey, (ByteString)BoundaryUtil.upperBound((ByteString)splitKey));
    }
}

