/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import io.netty.handler.ssl.SslContext;
import java.util.Optional;
import org.apache.bifromq.apiserver.APIServer;
import org.apache.bifromq.apiserver.IAPIServer;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.SettingProviderManager;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.api.APIServerConfig;
import org.apache.bifromq.starter.module.SSLUtil;
import org.apache.bifromq.starter.module.ServiceInjector;

public class APIServerModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<IAPIServer>>(){}).toProvider(APIServerProvider.class).asEagerSingleton();
    }

    private static class APIServerProvider
    implements Provider<Optional<IAPIServer>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private APIServerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IAPIServer> get() {
            APIServerConfig serverConfig = this.config.getApiServerConfig();
            if (!serverConfig.isEnable()) {
                return Optional.empty();
            }
            String apiHost = Strings.isNullOrEmpty((String)serverConfig.getHost()) ? "0.0.0.0" : serverConfig.getHost();
            SslContext sslContext = null;
            if (serverConfig.isEnableSSL()) {
                sslContext = SSLUtil.buildServerSslContext(serverConfig.getSslConfig());
            }
            return Optional.of(APIServer.builder().host(apiHost).port(serverConfig.getHttpPort()).maxContentLength(serverConfig.getMaxContentLength()).workerThreads(serverConfig.getWorkerThreads()).sslContext(sslContext).agentHost(this.injector.getInstance(IAgentHost.class)).trafficService(this.injector.getInstance(IRPCServiceTrafficService.class)).metaService(this.injector.getInstance(IBaseKVMetaService.class)).distClient(this.injector.getInstance(IDistClient.class)).inboxClient(this.injector.getInstance(IInboxClient.class)).sessionDictClient(this.injector.getInstance(ISessionDictClient.class)).retainClient(this.injector.getInstance(IRetainClient.class)).settingProvider((ISettingProvider)this.injector.getInstance(SettingProviderManager.class)).build());
        }
    }
}

