/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.lang.ref.Cleaner;
import java.util.function.Predicate;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBOptionsUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.DBOptions;
import org.slf4j.Logger;

class RocksDBCPableKVSpaceEpochHandle
extends RocksDBKVSpaceEpochHandle {
    private static final Cleaner CLEANER = Cleaner.create(EnvProvider.INSTANCE.newThreadFactory("kvspace-epoch-cleaner", true));
    private final RocksDBKVSpaceEpochHandle.SpaceMetrics metrics;
    private final Cleaner.Cleanable cleanable;

    RocksDBCPableKVSpaceEpochHandle(String id, File dir, Struct conf, Predicate<String> isRetired, Logger logger, Tags tags) {
        super(dir, conf, logger);
        this.metrics = new RocksDBKVSpaceEpochHandle.SpaceMetrics(id, this.db, this.dbOptions, this.cf, this.cfDesc.getOptions(), tags.and("gen", dir.getName()), logger);
        this.cleanable = CLEANER.register(this, new RocksDBKVSpaceEpochHandle.ClosableResources(id, dir.getName(), this.dbOptions, this.cfDesc, this.cf, this.db, this.checkpoint, dir, isRetired, this.metrics, logger));
    }

    @Override
    public void close() {
        this.cleanable.clean();
    }

    @Override
    protected DBOptions buildDBOptions(Struct conf) {
        return RocksDBOptionsUtil.buildCPableDBOption(conf);
    }

    @Override
    protected ColumnFamilyDescriptor buildCFDescriptor(Struct conf) {
        return RocksDBOptionsUtil.buildCPableCFDesc("default", conf);
    }
}

