/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TrieMap<V>
extends AbstractMap<String, V> {
    private Map<String, TrieMap<V>> children;
    private V value;

    private boolean isLeaf() {
        return this.value != null;
    }

    private TrieMap<V> getChildTrie(String key) {
        TrieMap curTrie = this;
        for (int i = 0; i < key.length(); ++i) {
            String element = String.valueOf(key.charAt(i));
            TrieMap trieMap = curTrie = curTrie.children != null ? curTrie.children.get(element) : null;
            if (curTrie != null) continue;
            return null;
        }
        return curTrie;
    }

    public V bestMatch(String key) {
        TrieMap<V> curTrie = this;
        V matched = curTrie.value;
        for (int i = 0; i < key.length(); ++i) {
            String element = String.valueOf(key.charAt(i));
            if (curTrie.children == null || !curTrie.children.containsKey(element)) break;
            curTrie = curTrie.children.get(element);
            if (curTrie.value == null) continue;
            matched = curTrie.value;
        }
        return matched;
    }

    @Override
    public int size() {
        int s = 0;
        if (this.children != null) {
            for (Map.Entry<String, TrieMap<V>> kTrieMapEntry : this.children.entrySet()) {
                s += kTrieMapEntry.getValue().size();
            }
        }
        if (this.isLeaf()) {
            ++s;
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.children == null && !this.isLeaf();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    public V get(String key) {
        TrieMap<V> curTrie = this.getChildTrie(key);
        return curTrie != null ? (V)curTrie.value : null;
    }

    @Override
    public V put(String key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        TrieMap<V> curTrie = this;
        for (int i = 0; i < key.length(); ++i) {
            String element = String.valueOf(key.charAt(i));
            if (curTrie.children == null) {
                curTrie.children = new HashMap<String, TrieMap<V>>();
            }
            TrieMap<V> parent = curTrie;
            curTrie = curTrie.children.get(element);
            if (curTrie != null) continue;
            curTrie = new TrieMap<V>();
            parent.children.put(element, curTrie);
        }
        V oldValue = curTrie.value;
        curTrie.value = value;
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            return this.remove((String)key);
        }
        return null;
    }

    public V remove(String key) {
        TrieMap<V> parent = null;
        TrieMap<V> curTrie = this;
        String lastKey = null;
        for (int i = 0; i < key.length(); ++i) {
            String element = String.valueOf(key.charAt(i));
            if (curTrie.children == null) {
                return null;
            }
            lastKey = element;
            parent = curTrie;
            curTrie = curTrie.children.get(element);
            if (curTrie != null) continue;
            return null;
        }
        V v = curTrie.value;
        if (parent != null) {
            parent.children.remove(lastKey);
        } else {
            this.value = null;
        }
        return v;
    }

    @Override
    public void clear() {
        this.value = null;
        this.children = null;
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        this.gatherKeys(keys, new StringBuffer());
        return keys;
    }

    private void gatherKeys(Set<String> keys, StringBuffer prefix) {
        if (this.children != null) {
            for (Map.Entry<String, TrieMap<V>> kTrieMapEntry : this.children.entrySet()) {
                StringBuffer p = new StringBuffer(prefix.length() + 1);
                p.append(prefix);
                p.append(kTrieMapEntry.getKey());
                kTrieMapEntry.getValue().gatherKeys(keys, p);
            }
        }
        if (this.value != null) {
            keys.add(prefix.toString());
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.gatherValues(values);
        return values;
    }

    private void gatherValues(List<V> values) {
        if (this.children != null) {
            for (Map.Entry<String, TrieMap<V>> kTrieMapEntry : this.children.entrySet()) {
                kTrieMapEntry.getValue().gatherValues(values);
            }
        }
        if (this.value != null) {
            values.add(this.value);
        }
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        LinkedHashSet<Map.Entry<String, V>> entries = new LinkedHashSet<Map.Entry<String, V>>();
        this.gatherEntries(entries, new StringBuffer());
        return entries;
    }

    private void gatherEntries(Set<Map.Entry<String, V>> entries, final StringBuffer prefix) {
        if (this.children != null) {
            for (Map.Entry<String, TrieMap<V>> kTrieMapEntry : this.children.entrySet()) {
                StringBuffer p = new StringBuffer(prefix.length() + 1);
                p.append(prefix);
                p.append(kTrieMapEntry.getKey());
                kTrieMapEntry.getValue().gatherEntries(entries, p);
            }
        }
        if (this.value != null) {
            entries.add(new Map.Entry<String, V>(){

                @Override
                public String getKey() {
                    return prefix.toString();
                }

                @Override
                public V getValue() {
                    return TrieMap.this.value;
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }
}

