/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.nameresolver;

import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.nameresolver.TrafficGovernorNameResolver;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceLandscape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficGovernorNameResolverProvider
extends NameResolverProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrafficGovernorNameResolverProvider.class);
    public static final String SCHEME = "tgov";
    public static final TrafficGovernorNameResolverProvider INSTANCE = new TrafficGovernorNameResolverProvider();
    private static final Map<String, TrafficGovernorNameResolver> RESOLVERS = new ConcurrentHashMap<String, TrafficGovernorNameResolver>();

    public static void register(String serviceUniqueName, IRPCServiceLandscape trafficDirector) {
        RESOLVERS.put(serviceUniqueName, new TrafficGovernorNameResolver(serviceUniqueName, trafficDirector));
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return RESOLVERS.get(targetUri.getAuthority());
        }
        return null;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return Integer.MAX_VALUE;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(SocketAddress.class);
    }

    @Generated
    private TrafficGovernorNameResolverProvider() {
    }

    static {
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)INSTANCE);
    }
}

