/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basekv.localengine.ICPableKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.IKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.IRestoreSession;
import org.apache.bifromq.basekv.localengine.RestoreMode;
import org.apache.bifromq.basekv.localengine.memory.InMemCPableKVEngine;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriterHelper;
import org.apache.bifromq.basekv.localengine.metrics.GeneralKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.slf4j.Logger;

class InMemCPableKVSpace
extends InMemKVSpace<InMemCPableKVEngine, InMemCPableKVSpace>
implements ICPableKVSpace {
    private final Cache<String, InMemKVSpaceCheckpoint> checkpoints;
    private final Gauge checkpointGauge;
    private final AtomicReference<InMemKVSpaceEpoch> activeEpoch = new AtomicReference<InMemKVSpaceEpoch>(new InMemKVSpaceEpoch());
    private volatile InMemKVSpaceCheckpoint latestCheckpoint;

    protected InMemCPableKVSpace(String id, Struct conf, InMemCPableKVEngine engine, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        super(id, conf, engine, onDestroy, opMeters, logger, tags);
        this.checkpoints = Caffeine.newBuilder().weakValues().build();
        this.checkpointGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)GeneralKVSpaceMetric.CheckpointNumGauge, () -> this.checkpoints.estimatedSize(), (Tags)Tags.of((String[])tags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkpoint() {
        InMemCPableKVSpace inMemCPableKVSpace = this;
        synchronized (inMemCPableKVSpace) {
            return (String)this.metadataRefresher.call(() -> {
                String cpId = UUID.randomUUID().toString();
                this.latestCheckpoint = new InMemKVSpaceCheckpoint(this.id, cpId, this.activeEpoch.get(), this.opMeters, this.logger);
                this.checkpoints.put((Object)cpId, (Object)this.latestCheckpoint);
                return cpId;
            });
        }
    }

    public Optional<IKVSpaceCheckpoint> openCheckpoint(String checkpointId) {
        return Optional.ofNullable((IKVSpaceCheckpoint)this.checkpoints.getIfPresent((Object)checkpointId));
    }

    public IRestoreSession startRestore(IRestoreSession.FlushListener flushListener) {
        return new RestoreSession(RestoreMode.Replace, flushListener);
    }

    public IRestoreSession startReceiving(IRestoreSession.FlushListener flushListener) {
        return new RestoreSession(RestoreMode.Overlay, flushListener);
    }

    protected void doClose() {
        this.checkpointGauge.close();
    }

    protected void doDestroy() {
        this.activeEpoch.set(new InMemKVSpaceEpoch());
    }

    protected InMemKVSpaceEpoch handle() {
        return this.activeEpoch.get();
    }

    protected void doOpen() {
    }

    public IKVSpaceMigratableWriter toWriter() {
        return new InMemKVSpaceMigratableWriter(this.id, this.activeEpoch.get(), (InMemCPableKVEngine)this.engine, this.syncContext, metadataUpdated -> {
            if (metadataUpdated.booleanValue()) {
                this.loadMetadata();
            }
        }, impact -> this.tracker.updateOnWrite((InMemKVSpaceWriterHelper.WriteImpact)impact, this.activeEpoch.get().dataMap()), this.opMeters, this.logger);
    }

    private class RestoreSession
    implements IRestoreSession {
        private final InMemKVSpaceEpoch staging;
        private final IRestoreSession.FlushListener flushListener;
        private final AtomicBoolean closed = new AtomicBoolean();
        private int ops = 0;
        private long bytes = 0L;

        private RestoreSession(RestoreMode mode, IRestoreSession.FlushListener flushListener) {
            switch (mode) {
                case Overlay: {
                    this.staging = new InMemKVSpaceEpoch(InMemCPableKVSpace.this.activeEpoch.get());
                    break;
                }
                case Replace: {
                    this.staging = new InMemKVSpaceEpoch();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported restore mode: " + String.valueOf(mode));
                }
            }
            this.flushListener = flushListener;
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new IllegalStateException("Restore session already closed");
            }
        }

        public IRestoreSession put(ByteString key, ByteString value) {
            this.ensureOpen();
            this.staging.putData(key, value);
            ++this.ops;
            this.bytes += (long)(key.size() + value.size());
            return this;
        }

        public IRestoreSession metadata(ByteString metaKey, ByteString metaValue) {
            this.ensureOpen();
            this.staging.setMetadata(metaKey, metaValue);
            ++this.ops;
            this.bytes += (long)(metaKey.size() + metaValue.size());
            return this;
        }

        public void done() {
            this.ensureOpen();
            if (this.closed.compareAndSet(false, true)) {
                InMemCPableKVSpace.this.syncContext().mutator().run(() -> {
                    InMemCPableKVSpace.this.activeEpoch.set(this.staging);
                    InMemCPableKVSpace.this.tracker.invalidateAll();
                    if (this.flushListener != null) {
                        this.flushListener.onFlush(this.ops, this.bytes);
                    }
                    InMemCPableKVSpace.this.loadMetadata();
                    return true;
                });
            }
        }

        public void abort() {
            if (this.closed.compareAndSet(false, true)) {
                // empty if block
            }
        }

        public int count() {
            return this.ops;
        }
    }
}

