/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt;

import com.google.common.util.concurrent.RateLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.netty4.NettyEventExecutorMetrics;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import lombok.Generated;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.mqtt.ConnListenerBuilder;
import org.apache.bifromq.mqtt.IMQTTBroker;
import org.apache.bifromq.mqtt.MQTTBrokerBuilder;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.ClientAddrHandler;
import org.apache.bifromq.mqtt.handler.ConditionalRejectHandler;
import org.apache.bifromq.mqtt.handler.ConnectionRateLimitHandler;
import org.apache.bifromq.mqtt.handler.MQTTMessageDebounceHandler;
import org.apache.bifromq.mqtt.handler.MQTTPreludeHandler;
import org.apache.bifromq.mqtt.handler.ProxyProtocolDetector;
import org.apache.bifromq.mqtt.handler.ProxyProtocolHandler;
import org.apache.bifromq.mqtt.handler.condition.DirectMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.HeapMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.ORCondition;
import org.apache.bifromq.mqtt.handler.ws.MqttOverWSHandler;
import org.apache.bifromq.mqtt.handler.ws.WebSocketOnlyHandler;
import org.apache.bifromq.mqtt.service.ILocalSessionServer;
import org.apache.bifromq.mqtt.session.MQTTSessionContext;
import org.apache.bifromq.mqtt.spi.UserPropsCustomizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MQTTBroker
implements IMQTTBroker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTBroker.class);
    private static final String MQTT_SUBPROTOCOL_CSV_LIST = "mqtt, mqttv3.1, mqttv3.1.1";
    private final MQTTBrokerBuilder builder;
    private final ILocalSessionServer sessionServer;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final RateLimiter connRateLimiter;
    private MQTTSessionContext sessionContext;
    private ChannelFuture tcpChannelF;
    private ChannelFuture tlsChannelF;
    private ChannelFuture wsChannelF;
    private ChannelFuture wssChannelF;
    private final UserPropsCustomizerFactory userPropsCustomizerFactory;

    public MQTTBroker(MQTTBrokerBuilder builder) {
        this.builder = builder;
        this.bossGroup = NettyEnv.createEventLoopGroup((int)builder.mqttBossELGThreads, (String)"mqtt-boss-elg");
        new NettyEventExecutorMetrics((Iterable)this.bossGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
        this.workerGroup = NettyEnv.createEventLoopGroup((int)builder.mqttWorkerELGThreads, (String)"mqtt-worker-elg");
        new NettyEventExecutorMetrics((Iterable)this.workerGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
        this.connRateLimiter = RateLimiter.create((double)builder.connectRateLimit);
        new NettyEventExecutorMetrics((Iterable)this.bossGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
        new NettyEventExecutorMetrics((Iterable)this.workerGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
        this.userPropsCustomizerFactory = new UserPropsCustomizerFactory(builder.userPropsCustomizerFactoryConfig);
        this.sessionServer = ILocalSessionServer.builder().rpcServerBuilder(builder.rpcServerBuilder).sessionRegistry(builder.sessionRegistry).distService(builder.distService).build();
    }

    @Override
    public final void start() {
        try {
            Channel channel;
            this.sessionContext = MQTTSessionContext.builder().serverId(this.builder.brokerId()).localSessionRegistry(this.builder.sessionRegistry).localDistService(this.builder.distService).authProvider(this.builder.authProvider).resourceThrottler(this.builder.resourceThrottler).eventCollector(this.builder.eventCollector).settingProvider(this.builder.settingProvider).distClient(this.builder.distClient).inboxClient(this.builder.inboxClient).retainClient(this.builder.retainClient).sessionDictClient(this.builder.sessionDictClient).clientBalancer(this.builder.clientBalancer).userPropsCustomizer(this.userPropsCustomizerFactory.create()).build();
            log.info("Starting MQTT broker");
            log.debug("Starting server channel");
            if (this.builder.tcpListenerBuilder != null) {
                this.tcpChannelF = this.bindTCPChannel(this.builder.tcpListenerBuilder);
                channel = this.tcpChannelF.sync().channel();
                log.debug("Accepting mqtt connection over tcp channel at {}", (Object)channel.localAddress());
            }
            if (this.builder.tlsListenerBuilder != null) {
                this.tlsChannelF = this.bindTLSChannel(this.builder.tlsListenerBuilder);
                channel = this.tlsChannelF.sync().channel();
                log.debug("Accepting mqtt connection over tls channel at {}", (Object)channel.localAddress());
            }
            if (this.builder.wsListenerBuilder != null) {
                this.wsChannelF = this.bindWSChannel(this.builder.wsListenerBuilder);
                channel = this.wsChannelF.sync().channel();
                log.debug("Accepting mqtt connection over ws channel at {}", (Object)channel.localAddress());
            }
            if (this.builder.wssListenerBuilder != null) {
                this.wssChannelF = this.bindWSSChannel(this.builder.wssListenerBuilder);
                channel = this.wssChannelF.sync().channel();
                log.debug("Accepting mqtt connection over wss channel at {}", (Object)channel.localAddress());
            }
            log.info("MQTT broker started");
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final void close() {
        log.info("Stopping MQTT broker");
        if (this.tcpChannelF != null) {
            this.tcpChannelF.channel().close().syncUninterruptibly();
            log.debug("Stopped accepting mqtt connection over tcp channel");
        }
        if (this.tlsChannelF != null) {
            this.tlsChannelF.channel().close().syncUninterruptibly();
            log.debug("Stopped accepting mqtt connection over tls channel");
        }
        if (this.wsChannelF != null) {
            this.wsChannelF.channel().close().syncUninterruptibly();
            log.debug("Stopped accepting mqtt connection over ws channel");
        }
        if (this.wssChannelF != null) {
            this.wssChannelF.channel().close().syncUninterruptibly();
            log.debug("Stopped accepting mqtt connection over wss channel");
        }
        this.sessionContext.localSessionRegistry.disconnectAll(this.builder.disconnectRate).join();
        log.debug("All mqtt connection closed");
        this.sessionContext.awaitBgTasksFinish().join();
        log.debug("All background tasks done");
        this.bossGroup.shutdownGracefully().syncUninterruptibly();
        log.debug("Boss group shutdown");
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
        log.debug("Worker group shutdown");
        this.userPropsCustomizerFactory.close();
        log.info("MQTT broker stopped");
    }

    private ChannelFuture bindTCPChannel(ConnListenerBuilder.TCPConnListenerBuilder connBuilder) {
        return this.buildChannel(connBuilder, new MQTTChannelInitializer(){

            @Override
            protected void initChannel(SocketChannel ch) {
                super.initChannel(ch);
                ch.pipeline().addLast("connRateLimiter", (ChannelHandler)new ConnectionRateLimitHandler(MQTTBroker.this.connRateLimiter, MQTTBroker.this.builder.eventCollector, p -> {
                    p.addLast("trafficShaper", (ChannelHandler)new ChannelTrafficShapingHandler(MQTTBroker.this.builder.writeLimit, MQTTBroker.this.builder.readLimit));
                    p.addLast(MqttEncoder.class.getName(), (ChannelHandler)MqttEncoder.INSTANCE);
                    p.addLast(MqttDecoder.class.getName(), (ChannelHandler)new MqttDecoder(MQTTBroker.this.builder.maxBytesInMessage));
                    p.addLast("MQTTMessageDebounceHandler", (ChannelHandler)new MQTTMessageDebounceHandler());
                    p.addLast("ConditionalRejectHandler", (ChannelHandler)new ConditionalRejectHandler(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE), MQTTBroker.this.sessionContext.eventCollector));
                    p.addLast("MqttPreludeHandler", (ChannelHandler)new MQTTPreludeHandler(MQTTBroker.this.builder.connectTimeoutSeconds));
                }));
            }
        });
    }

    private ChannelFuture bindTLSChannel(final ConnListenerBuilder.TLSConnListenerBuilder connBuilder) {
        return this.buildChannel(connBuilder, new MQTTChannelInitializer(){

            @Override
            protected void initChannel(SocketChannel ch) {
                super.initChannel(ch);
                ch.pipeline().addLast("connRateLimiter", (ChannelHandler)new ConnectionRateLimitHandler(MQTTBroker.this.connRateLimiter, MQTTBroker.this.builder.eventCollector, p -> {
                    p.addLast("ssl", (ChannelHandler)connBuilder2.sslContext.newHandler(ch.alloc()));
                    p.addLast("trafficShaper", (ChannelHandler)new ChannelTrafficShapingHandler(MQTTBroker.this.builder.writeLimit, MQTTBroker.this.builder.readLimit));
                    p.addLast(MqttEncoder.class.getName(), (ChannelHandler)MqttEncoder.INSTANCE);
                    p.addLast(MqttDecoder.class.getName(), (ChannelHandler)new MqttDecoder(MQTTBroker.this.builder.maxBytesInMessage));
                    p.addLast("MQTTMessageDebounceHandler", (ChannelHandler)new MQTTMessageDebounceHandler());
                    p.addLast("ConditionalRejectHandler", (ChannelHandler)new ConditionalRejectHandler(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE), MQTTBroker.this.sessionContext.eventCollector));
                    p.addLast("MqttPreludeHandler", (ChannelHandler)new MQTTPreludeHandler(MQTTBroker.this.builder.connectTimeoutSeconds));
                }));
            }
        });
    }

    private ChannelFuture bindWSChannel(final ConnListenerBuilder.WSConnListenerBuilder connBuilder) {
        return this.buildChannel(connBuilder, new MQTTChannelInitializer(){

            @Override
            protected void initChannel(SocketChannel ch) {
                super.initChannel(ch);
                ch.pipeline().addLast("connRateLimiter", (ChannelHandler)new ConnectionRateLimitHandler(MQTTBroker.this.connRateLimiter, MQTTBroker.this.builder.eventCollector, p -> {
                    p.addLast("trafficShaper", (ChannelHandler)new ChannelTrafficShapingHandler(MQTTBroker.this.builder.writeLimit, MQTTBroker.this.builder.readLimit));
                    p.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                    p.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                    p.addLast("remoteAddr", (ChannelHandler)new ClientAddrHandler());
                    p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                    p.addLast("webSocketOnly", (ChannelHandler)new WebSocketOnlyHandler(connBuilder.path()));
                    p.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler(connBuilder.path(), MQTTBroker.MQTT_SUBPROTOCOL_CSV_LIST));
                    p.addLast("webSocketHandshakeListener", (ChannelHandler)new MqttOverWSHandler(MQTTBroker.this.builder.maxBytesInMessage, MQTTBroker.this.builder.connectTimeoutSeconds, MQTTBroker.this.sessionContext.eventCollector));
                }));
            }
        });
    }

    private ChannelFuture bindWSSChannel(final ConnListenerBuilder.WSSConnListenerBuilder connBuilder) {
        return this.buildChannel(connBuilder, new MQTTChannelInitializer(){

            @Override
            protected void initChannel(SocketChannel ch) {
                super.initChannel(ch);
                ch.pipeline().addLast("connRateLimiter", (ChannelHandler)new ConnectionRateLimitHandler(MQTTBroker.this.connRateLimiter, MQTTBroker.this.builder.eventCollector, p -> {
                    p.addLast("ssl", (ChannelHandler)connBuilder2.sslContext.newHandler(ch.alloc()));
                    p.addLast("trafficShaper", (ChannelHandler)new ChannelTrafficShapingHandler(MQTTBroker.this.builder.writeLimit, MQTTBroker.this.builder.readLimit));
                    p.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                    p.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                    p.addLast(ClientAddrHandler.class.getName(), (ChannelHandler)new ClientAddrHandler());
                    p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                    p.addLast("webSocketOnly", (ChannelHandler)new WebSocketOnlyHandler(connBuilder.path()));
                    p.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler(connBuilder.path(), MQTTBroker.MQTT_SUBPROTOCOL_CSV_LIST));
                    p.addLast("webSocketHandshakeListener", (ChannelHandler)new MqttOverWSHandler(MQTTBroker.this.builder.maxBytesInMessage, MQTTBroker.this.builder.connectTimeoutSeconds, MQTTBroker.this.sessionContext.eventCollector));
                }));
            }
        });
    }

    private <T extends ConnListenerBuilder<T>> ChannelFuture buildChannel(T builder, MQTTChannelInitializer chInitializer) {
        ServerBootstrap b = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NettyEnv.determineServerSocketChannelClass((EventLoopGroup)this.bossGroup))).childHandler((ChannelHandler)chInitializer).childAttr(ChannelAttrs.MQTT_SESSION_CTX, (Object)this.sessionContext);
        builder.options.forEach((k, v) -> b.option(k, v));
        builder.childOptions.forEach((k, v) -> b.childOption(k, v));
        return b.bind(builder.host, builder.port);
    }

    private static abstract class MQTTChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private MQTTChannelInitializer() {
        }

        protected void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(ProxyProtocolDetector.class.getName(), (ChannelHandler)new ProxyProtocolDetector()).addLast(HAProxyMessageDecoder.class.getName(), (ChannelHandler)new HAProxyMessageDecoder()).addLast(ProxyProtocolHandler.class.getName(), (ChannelHandler)new ProxyProtocolHandler());
        }
    }
}

