/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.service;

import com.google.common.util.concurrent.RateLimiter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bifromq.mqtt.service.ILocalSessionRegistry;
import org.apache.bifromq.mqtt.session.IMQTTSession;

public class LocalSessionRegistry
implements ILocalSessionRegistry {
    private final ConcurrentMap<String, IMQTTSession> sessionMap = new ConcurrentHashMap<String, IMQTTSession>();
    private final Gauge connNumGauge = Gauge.builder((String)"mqtt.server.connection.gauge", this.sessionMap::size).register((MeterRegistry)Metrics.globalRegistry);

    @Override
    public void add(String sessionId, IMQTTSession session) {
        this.sessionMap.putIfAbsent(sessionId, session);
    }

    @Override
    public boolean remove(String sessionId, IMQTTSession session) {
        return this.sessionMap.remove(sessionId, session);
    }

    @Override
    public IMQTTSession get(String sessionId) {
        return (IMQTTSession)this.sessionMap.get(sessionId);
    }

    @Override
    public CompletableFuture<Void> disconnectAll(int disconnectRate) {
        RateLimiter limiter = RateLimiter.create((double)Math.max(1, disconnectRate));
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (String sessionId : this.sessionMap.keySet()) {
            limiter.acquire();
            futures.add(this.disconnect(sessionId));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<Void> disconnect(String sessionId) {
        IMQTTSession session = (IMQTTSession)this.sessionMap.remove(sessionId);
        if (session != null) {
            return session.onServerShuttingDown();
        }
        return CompletableFuture.completedFuture(null);
    }
}

