/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.store.proto.KVRangeRWReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRWRequest;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.slf4j.Logger;

class ManagedMutationPipeline
implements IMutationPipeline {
    private final Logger log;
    private final Disposable disposable;
    private final Consumer<KVRangeDescriptor> routePatcher;
    private volatile IRPCClient.IRequestPipeline<KVRangeRWRequest, KVRangeRWReply> ppln;

    ManagedMutationPipeline(Observable<IRPCClient.IRequestPipeline<KVRangeRWRequest, KVRangeRWReply>> pplnObservable, Consumer<KVRangeDescriptor> routePatcher, Logger log) {
        this.log = log;
        this.routePatcher = routePatcher;
        this.disposable = pplnObservable.subscribe(next -> {
            IRPCClient.IRequestPipeline<KVRangeRWRequest, KVRangeRWReply> old = this.ppln;
            this.ppln = next;
            if (old != null) {
                old.close();
            }
        });
    }

    @Override
    public CompletableFuture<KVRangeRWReply> execute(KVRangeRWRequest request) {
        this.log.trace("Requesting rw range:req={}", (Object)request);
        return this.ppln.invoke((Object)request).thenApply(v -> {
            if (v.hasLatest()) {
                this.routePatcher.accept(v.getLatest());
            }
            return v;
        });
    }

    @Override
    public void close() {
        this.disposable.dispose();
        if (this.ppln != null) {
            this.ppln.close();
        }
    }
}

