/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.base.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class CascadeCancelCompletableFuture<T>
extends CompletableFuture<T> {
    private final Shared shared;

    private CascadeCancelCompletableFuture(Shared shared) {
        this.shared = shared;
    }

    private CascadeCancelCompletableFuture(CompletableFuture<?> root) {
        this.shared = new Shared(root);
    }

    public static <T> CompletableFuture<T> fromRoot(CompletableFuture<T> root) {
        CascadeCancelCompletableFuture head = new CascadeCancelCompletableFuture(root);
        root.whenComplete((T v, U ex) -> {
            if (ex == null) {
                head.complete(v);
            } else {
                head.completeExceptionally((Throwable)ex);
            }
        });
        return head;
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new CascadeCancelCompletableFuture<T>(this.shared);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelUpstream(mayInterruptIfRunning);
        return super.cancel(mayInterruptIfRunning);
    }

    private void cancelUpstream(boolean mayInterruptIfRunning) {
        Node n = this.shared.head;
        while (n != null) {
            CompletableFuture<?> f = n.future;
            if (!f.isDone()) {
                f.cancel(mayInterruptIfRunning);
                break;
            }
            n = n.next;
        }
    }

    private void addCancelable(CompletableFuture<?> cf) {
        this.shared.append(cf);
    }

    private <U> Function<T, CompletionStage<U>> wrapCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return t -> {
            CompletionStage stage = (CompletionStage)fn.apply(t);
            if (stage instanceof CompletableFuture) {
                this.addCancelable((CompletableFuture)stage);
            }
            return stage;
        };
    }

    private Function<Throwable, CompletionStage<T>> wrapExCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return ex -> {
            CompletionStage stage = (CompletionStage)fn.apply((Throwable)ex);
            if (stage instanceof CompletableFuture) {
                this.addCancelable((CompletableFuture)stage);
            }
            return stage;
        };
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenCompose(this.wrapCompose(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenComposeAsync(this.wrapCompose(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return super.thenComposeAsync(this.wrapCompose(fn), executor);
    }

    @Override
    public CompletableFuture<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return super.exceptionallyCompose(this.wrapExCompose(fn));
    }

    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return super.exceptionallyComposeAsync(this.wrapExCompose(fn));
    }

    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        return super.exceptionallyComposeAsync(this.wrapExCompose(fn), executor);
    }

    private static final class Shared {
        private static final VarHandle TAIL;
        final Node head;
        volatile Node tail;

        Shared(CompletableFuture<?> root) {
            Node n;
            this.head = n = new Node(root);
            this.tail = n;
        }

        void append(CompletableFuture<?> cf) {
            Node n = new Node(cf);
            Node prev = TAIL.getAndSet(this, n);
            prev.next = n;
        }

        static {
            try {
                TAIL = MethodHandles.lookup().findVarHandle(Shared.class, "tail", Node.class);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class Node {
        final CompletableFuture<?> future;
        volatile Node next;

        Node(CompletableFuture<?> future) {
            this.future = future;
        }
    }
}

