/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.hinter;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.SplitHint;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.range.hinter.IKVLoadRecord;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinter;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.dist.rpc.proto.BatchMatchRequest;
import org.apache.bifromq.dist.rpc.proto.BatchUnmatchRequest;
import org.apache.bifromq.dist.rpc.proto.MatchRoute;
import org.apache.bifromq.dist.worker.hinter.RecordEstimation;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.apache.bifromq.type.RouteMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanoutSplitHinter
implements IKVRangeSplitHinter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FanoutSplitHinter.class);
    public static final String TYPE = "fanout_split_hinter";
    public static final String LOAD_TYPE_FANOUT_TOPIC_FILTERS = "fanout_topicfilters";
    public static final String LOAD_TYPE_FANOUT_SCALE = "fanout_scale";
    private final int splitAtScale;
    private final Supplier<IKVRangeReader> readerSupplier;
    private final Map<ByteString, FanOutSplit> fanoutSplitKeys = new ConcurrentHashMap<ByteString, FanOutSplit>();
    private final Gauge fanOutTopicFiltersGauge;
    private final Gauge fanOutScaleGauge;
    private volatile Boundary boundary;

    public FanoutSplitHinter(Supplier<IKVRangeReader> readerSupplier, int splitAtScale, String ... tags) {
        this.splitAtScale = splitAtScale;
        this.readerSupplier = readerSupplier;
        try (IKVRangeReader reader = readerSupplier.get();){
            this.boundary = reader.boundary();
        }
        this.fanOutTopicFiltersGauge = Gauge.builder((String)"dist.fanout.topicfilters", this.fanoutSplitKeys::size).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.fanOutScaleGauge = Gauge.builder((String)"dist.fanout.scale", () -> this.fanoutSplitKeys.values().stream().map(f -> f.estimation.dataSize / (long)f.estimation.recordSize).reduce(Long::sum).orElse(0L)).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public void recordQuery(ROCoProcInput input, IKVLoadRecord ioRecord) {
    }

    public void recordMutate(RWCoProcInput input, IKVLoadRecord ioRecord) {
        assert (input.hasDistService());
        switch (input.getDistService().getTypeCase()) {
            case BATCHMATCH: {
                BatchMatchRequest request = input.getDistService().getBatchMatch();
                HashMap<ByteString, RecordEstimation> routeKeyLoads = new HashMap<ByteString, RecordEstimation>();
                request.getRequestsMap().forEach((tenantId, records) -> records.getRouteList().forEach(route -> {
                    RouteMatcher routeMatcher = route.getMatcher();
                    if (routeMatcher.getType() == RouteMatcher.Type.Normal) {
                        ByteString routeKey = KVSchemaUtil.toNormalRouteKey((String)tenantId, (RouteMatcher)routeMatcher, (String)KVSchemaUtil.toReceiverUrl((MatchRoute)route));
                        routeKeyLoads.computeIfAbsent(routeKey, k -> new RecordEstimation(false)).addRecordSize(routeKey.size());
                    } else {
                        ByteString routeKey = KVSchemaUtil.toGroupRouteKey((String)tenantId, (RouteMatcher)route.getMatcher());
                        routeKeyLoads.computeIfAbsent(routeKey, k -> new RecordEstimation(false)).addRecordSize(routeKey.size());
                    }
                }));
                this.doEstimate(routeKeyLoads);
                break;
            }
            case BATCHUNMATCH: {
                BatchUnmatchRequest request = input.getDistService().getBatchUnmatch();
                HashMap<ByteString, RecordEstimation> routeKeyLoads = new HashMap<ByteString, RecordEstimation>();
                request.getRequestsMap().forEach((tenantId, records) -> records.getRouteList().forEach(route -> {
                    RouteMatcher routeMatcher = route.getMatcher();
                    if (routeMatcher.getType() == RouteMatcher.Type.Normal) {
                        ByteString routeKey = KVSchemaUtil.toNormalRouteKey((String)tenantId, (RouteMatcher)routeMatcher, (String)KVSchemaUtil.toReceiverUrl((MatchRoute)route));
                        routeKeyLoads.computeIfAbsent(routeKey, k -> new RecordEstimation(true)).addRecordSize(routeKey.size());
                    } else {
                        ByteString routeKey = KVSchemaUtil.toGroupRouteKey((String)tenantId, (RouteMatcher)route.getMatcher());
                        routeKeyLoads.computeIfAbsent(routeKey, k -> new RecordEstimation(true)).addRecordSize(routeKey.size());
                    }
                }));
                this.doEstimate(routeKeyLoads);
                break;
            }
        }
    }

    public void reset(Boundary boundary) {
        this.boundary = boundary;
        HashMap<ByteString, RecordEstimation> finished = new HashMap<ByteString, RecordEstimation>();
        for (Map.Entry<ByteString, FanOutSplit> entry : this.fanoutSplitKeys.entrySet()) {
            ByteString matchRecordKeyPrefix = entry.getKey();
            FanOutSplit fanoutSplit = entry.getValue();
            if (BoundaryUtil.inRange((ByteString)fanoutSplit.splitKey, (Boundary)boundary)) continue;
            this.fanoutSplitKeys.remove(matchRecordKeyPrefix);
            RecordEstimation recordEst = new RecordEstimation(false);
            recordEst.addRecordSize(fanoutSplit.estimation.recordSize);
            finished.put(matchRecordKeyPrefix, recordEst);
        }
        this.doEstimate(finished);
    }

    public SplitHint estimate() {
        Optional firstSplit = this.fanoutSplitKeys.entrySet().stream().findFirst();
        SplitHint.Builder hintBuilder = SplitHint.newBuilder().setType(TYPE).putLoad(LOAD_TYPE_FANOUT_TOPIC_FILTERS, (double)this.fanoutSplitKeys.size()).putLoad(LOAD_TYPE_FANOUT_SCALE, 0.0);
        firstSplit.ifPresent(s -> {
            if (!BoundaryUtil.isSplittable((Boundary)this.boundary, (ByteString)((FanOutSplit)s.getValue()).splitKey)) {
                this.fanoutSplitKeys.remove(s.getKey());
            } else {
                hintBuilder.setSplitKey(((FanOutSplit)s.getValue()).splitKey);
                hintBuilder.putLoad(LOAD_TYPE_FANOUT_SCALE, (double)((FanOutSplit)s.getValue()).estimation.dataSize / (double)((FanOutSplit)s.getValue()).estimation.recordSize);
            }
        });
        return hintBuilder.build();
    }

    public void close() {
        Metrics.globalRegistry.remove((Meter)this.fanOutTopicFiltersGauge);
        Metrics.globalRegistry.remove((Meter)this.fanOutScaleGauge);
    }

    private void doEstimate(Map<ByteString, RecordEstimation> routeKeyLoads) {
        block13: {
            HashMap splitCandidate = new HashMap();
            try (IKVRangeReader reader = this.readerSupplier.get();){
                routeKeyLoads.forEach((matchRecordKeyPrefix, recordEst) -> {
                    long dataSize = reader.size(Boundary.newBuilder().setStartKey(matchRecordKeyPrefix).setEndKey(BoundaryUtil.upperBound((ByteString)matchRecordKeyPrefix)).build()) - (long)recordEst.tombstoneSize();
                    long fanOutScale = dataSize / (long)recordEst.avgRecordSize();
                    if (fanOutScale >= (long)this.splitAtScale) {
                        splitCandidate.put(matchRecordKeyPrefix, new RangeEstimation(dataSize, recordEst.avgRecordSize()));
                    } else if (this.fanoutSplitKeys.containsKey(matchRecordKeyPrefix) && (double)fanOutScale < 0.5 * (double)this.splitAtScale) {
                        this.fanoutSplitKeys.remove(matchRecordKeyPrefix);
                    }
                });
                if (splitCandidate.isEmpty()) break block13;
                try (IKVIterator itr = reader.iterator();){
                    for (ByteString routeKey : splitCandidate.keySet()) {
                        RangeEstimation recEst = (RangeEstimation)splitCandidate.get(routeKey);
                        this.fanoutSplitKeys.computeIfAbsent(routeKey, k -> {
                            int i = 0;
                            itr.seek(routeKey);
                            while (itr.isValid()) {
                                if (i++ >= this.splitAtScale) {
                                    return new FanOutSplit(recEst, itr.key());
                                }
                                itr.next();
                            }
                            return null;
                        });
                    }
                }
            }
        }
    }

    private record FanOutSplit(RangeEstimation estimation, ByteString splitKey) {
    }

    private record RangeEstimation(long dataSize, int recordSize) {
    }
}

