/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.authprovider;

import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.authprovider.type.Denied;
import org.apache.bifromq.plugin.authprovider.type.Error;
import org.apache.bifromq.plugin.authprovider.type.Failed;
import org.apache.bifromq.plugin.authprovider.type.Granted;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.Success;
import org.apache.bifromq.type.ClientInfo;
import org.pf4j.ExtensionPoint;

public interface IAuthProvider
extends ExtensionPoint {
    public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData var1);

    default public CompletableFuture<MQTT5AuthResult> auth(MQTT5AuthData authData) {
        MQTT3AuthData.Builder mqtt3AuthDataBuilder = MQTT3AuthData.newBuilder();
        if (authData.hasCert()) {
            mqtt3AuthDataBuilder.setCert(authData.getCert());
        }
        if (authData.hasUsername()) {
            mqtt3AuthDataBuilder.setUsername(authData.getUsername());
        }
        if (authData.hasPassword()) {
            mqtt3AuthDataBuilder.setPassword(authData.getPassword());
        }
        if (authData.hasClientId()) {
            mqtt3AuthDataBuilder.setClientId(authData.getClientId());
        }
        mqtt3AuthDataBuilder.setRemoteAddr(authData.getRemoteAddr());
        mqtt3AuthDataBuilder.setRemotePort(authData.getRemotePort());
        mqtt3AuthDataBuilder.setClientId(authData.getClientId());
        return this.auth(mqtt3AuthDataBuilder.build()).thenApply(mqtt3AuthResult -> {
            MQTT5AuthResult.Builder mqtt5AuthResultBuilder = MQTT5AuthResult.newBuilder();
            switch (mqtt3AuthResult.getTypeCase()) {
                case OK: {
                    mqtt5AuthResultBuilder.setSuccess(Success.newBuilder().setTenantId(mqtt3AuthResult.getOk().getTenantId()).setUserId(mqtt3AuthResult.getOk().getUserId()).putAllAttrs(mqtt3AuthResult.getOk().getAttrsMap()).build());
                    break;
                }
                case REJECT: {
                    Failed.Builder failedBuilder = Failed.newBuilder();
                    switch (mqtt3AuthResult.getReject().getCode()) {
                        case BadPass: {
                            failedBuilder.setCode(Failed.Code.BadPass);
                            break;
                        }
                        case NotAuthorized: {
                            failedBuilder.setCode(Failed.Code.NotAuthorized);
                            break;
                        }
                        case Error: {
                            failedBuilder.setCode(Failed.Code.Error);
                        }
                    }
                    if (mqtt3AuthResult.getReject().hasReason()) {
                        failedBuilder.setReason(mqtt3AuthResult.getReject().getReason());
                    }
                    mqtt5AuthResultBuilder.setFailed(failedBuilder.build());
                }
            }
            return mqtt5AuthResultBuilder.build();
        });
    }

    default public CompletableFuture<MQTT5ExtendedAuthResult> extendedAuth(MQTT5ExtendedAuthData authData) {
        return CompletableFuture.completedFuture(MQTT5ExtendedAuthResult.newBuilder().setFailed(Failed.newBuilder().setCode(Failed.Code.NotAuthorized).setReason("Not supported").build()).build());
    }

    @Deprecated(since="3.0")
    public CompletableFuture<Boolean> check(ClientInfo var1, MQTTAction var2);

    default public CompletableFuture<CheckResult> checkPermission(ClientInfo client, MQTTAction action) {
        return this.check(client, action).handle((granted, e) -> {
            if (e != null) {
                return CheckResult.newBuilder().setError(Error.newBuilder().setReason(e.getMessage()).build()).build();
            }
            if (granted.booleanValue()) {
                return CheckResult.newBuilder().setGranted(Granted.getDefaultInstance()).build();
            }
            return CheckResult.newBuilder().setDenied(Denied.getDefaultInstance()).build();
        });
    }

    default public void close() {
    }
}

