/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.deliverer;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basescheduler.BatchCallScheduler;
import org.apache.bifromq.basescheduler.IBatchCallBuilderFactory;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.deliverer.BatchDeliveryCallBuilderFactory;
import org.apache.bifromq.deliverer.DelivererKey;
import org.apache.bifromq.deliverer.DeliveryCall;
import org.apache.bifromq.deliverer.DeliveryCallResult;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.sysprops.props.DataPlaneMaxBurstLatencyMillis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeliverer
extends BatchCallScheduler<DeliveryCall, DeliveryCallResult, DelivererKey>
implements IMessageDeliverer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageDeliverer.class);

    public MessageDeliverer(BatchDeliveryCallBuilderFactory batchDeliveryCallBuilderFactory) {
        super((IBatchCallBuilderFactory)batchDeliveryCallBuilderFactory, Duration.ofMillis((Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get()).toNanos());
    }

    public CompletableFuture<DeliveryCallResult> schedule(DeliveryCall request) {
        return super.schedule((Object)request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BackPressureException) {
                return DeliveryCallResult.BACK_PRESSURE_REJECTED;
            }
            log.error("Failed to schedule delivery call", e);
            return DeliveryCallResult.ERROR;
        }));
    }

    protected Optional<DelivererKey> find(DeliveryCall request) {
        return Optional.of(request.delivererKey);
    }
}

