/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store.gc;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.client.exception.InternalErrorException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.proto.KVRangeRWRequest;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.apache.bifromq.retain.rpc.proto.GCReply;
import org.apache.bifromq.retain.rpc.proto.GCRequest;
import org.apache.bifromq.retain.rpc.proto.RetainServiceRWCoProcInput;
import org.apache.bifromq.retain.store.gc.IRetainStoreGCProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainStoreGCProcessor
implements IRetainStoreGCProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetainStoreGCProcessor.class);
    private final IBaseKVStoreClient storeClient;
    private final String localServerId;

    public RetainStoreGCProcessor(IBaseKVStoreClient storeClient, String localServerId) {
        this.storeClient = storeClient;
        this.localServerId = localServerId;
    }

    @Override
    public CompletableFuture<IRetainStoreGCProcessor.Result> gc(long reqId, String tenantId, Integer expirySeconds, long now) {
        Boundary boundary = tenantId == null ? BoundaryUtil.FULL_BOUNDARY : BoundaryUtil.toBoundary((ByteString)KVSchemaUtil.tenantBeginKey((String)tenantId), (ByteString)BoundaryUtil.upperBound((ByteString)KVSchemaUtil.tenantBeginKey((String)tenantId)));
        CompletableFuture[] gcFutures = (CompletableFuture[])KVRangeRouterUtil.findByBoundary((Boundary)boundary, (NavigableMap)this.storeClient.latestEffectiveRouter()).stream().filter(k -> this.localServerId == null || k.leader().equals(this.localServerId)).map(rangeSetting -> this.gcRange(reqId, (KVRangeSetting)rangeSetting, tenantId, expirySeconds, now)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(gcFutures).thenApply(v -> Arrays.stream(gcFutures).map(CompletableFuture::join).toList())).thenApply(v -> IRetainStoreGCProcessor.Result.OK)).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof TryLaterException) {
                return IRetainStoreGCProcessor.Result.TRY_LATER;
            }
            return IRetainStoreGCProcessor.Result.ERROR;
        }));
    }

    private CompletableFuture<GCReply> gcRange(long reqId, KVRangeSetting rangeSetting, String tenantId, Integer expirySeconds, long now) {
        log.debug("[RetainStore] gc running: reqId={}, rangeId={}", (Object)reqId, (Object)KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()));
        GCRequest.Builder reqBuilder = GCRequest.newBuilder().setReqId(reqId).setNow(now);
        if (tenantId != null) {
            reqBuilder.setTenantId(tenantId);
        }
        if (expirySeconds != null) {
            reqBuilder.setExpirySeconds(expirySeconds.intValue());
        }
        return this.storeClient.execute(rangeSetting.leader(), KVRangeRWRequest.newBuilder().setReqId(reqId).setKvRangeId(rangeSetting.id()).setVer(rangeSetting.ver()).setRwCoProc(RWCoProcInput.newBuilder().setRetainService(RetainServiceRWCoProcInput.newBuilder().setGc(reqBuilder.build()).build()).build()).build()).thenApply(reply -> {
            switch (reply.getCode()) {
                case Ok: {
                    log.debug("[RetainStore] gc done: reqId={}, rangeId={}", (Object)reqId, (Object)KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()));
                    return reply.getRwCoProcResult().getRetainService().getGc();
                }
                case TryLater: 
                case BadVersion: {
                    log.debug("[DistWorker] gc rejected: reqId={}, rangeId={}, reason={}", new Object[]{reqId, KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()), reply.getCode()});
                    throw new TryLaterException();
                }
            }
            log.debug("[DistWorker] gc error: reqId={}, rangeId={}, reason={}", new Object[]{reqId, KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()), reply.getCode()});
            throw new InternalErrorException();
        });
    }
}

